/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.brain.warden;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class GoToTargetLocation<E extends Mob>
extends Behavior<E> {
    private final MemoryModuleType<BlockPos> locationMemory;
    private final int closeEnoughDistance;
    private final float speedModifier;

    public GoToTargetLocation(MemoryModuleType<BlockPos> locationMemory, int closeEnoughDistance, float speedModifier) {
        super((Map)ImmutableMap.of(locationMemory, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED));
        this.locationMemory = locationMemory;
        this.closeEnoughDistance = closeEnoughDistance;
        this.speedModifier = speedModifier;
    }

    protected void start(ServerLevel level, E entity, long time) {
        BlockPos pos = this.getTargetLocation((Mob)entity);
        boolean inRange = pos.m_123314_((Vec3i)entity.m_142538_(), (double)this.closeEnoughDistance);
        if (!inRange) {
            BehaviorUtils.m_22617_(entity, (BlockPos)GoToTargetLocation.getNearbyPos(entity, pos), (float)this.speedModifier, (int)this.closeEnoughDistance);
        }
    }

    private static BlockPos getNearbyPos(Mob mob, BlockPos pos) {
        Random random = mob.f_19853_.m_5822_();
        return pos.m_142082_(GoToTargetLocation.getRandomOffset(random), 0, GoToTargetLocation.getRandomOffset(random));
    }

    private static int getRandomOffset(Random random) {
        return random.nextInt(3) - 1;
    }

    private BlockPos getTargetLocation(Mob mob) {
        return (BlockPos)mob.m_6274_().m_21952_(this.locationMemory).get();
    }
}

