/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.brain.warden;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class ForgetAttackTarget<E extends Mob>
extends Behavior<E> {
    private final Predicate<LivingEntity> alternativeCondition;
    private final BiConsumer<E, LivingEntity> forgetCallback;
    private final boolean shouldForgetIfTargetUnreachable;

    public ForgetAttackTarget(Predicate<LivingEntity> alternativeCondition, BiConsumer<E, LivingEntity> forgetCallback, boolean shouldForgetIfTargetUnreachable) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26326_, (Object)MemoryStatus.REGISTERED));
        this.alternativeCondition = alternativeCondition;
        this.forgetCallback = forgetCallback;
        this.shouldForgetIfTargetUnreachable = shouldForgetIfTargetUnreachable;
    }

    protected void start(ServerLevel level, E entity, long time) {
        LivingEntity target = this.getAttackTarget(entity);
        if (!entity.m_6779_(target)) {
            this.forgetAttackTarget(entity);
        } else if (this.shouldForgetIfTargetUnreachable && ForgetAttackTarget.cannotReachTarget(entity)) {
            this.forgetAttackTarget(entity);
        } else if (this.isAttackTargetDead(entity)) {
            this.forgetAttackTarget(entity);
        } else if (this.isAttackTargetInAnotherWorld(entity)) {
            this.forgetAttackTarget(entity);
        } else if (this.alternativeCondition.test(this.getAttackTarget(entity))) {
            this.forgetAttackTarget(entity);
        }
    }

    private boolean isAttackTargetInAnotherWorld(E entity) {
        return this.getAttackTarget(entity).f_19853_ != ((Mob)entity).f_19853_;
    }

    private LivingEntity getAttackTarget(E entity) {
        return (LivingEntity)entity.m_6274_().m_21952_(MemoryModuleType.f_26372_).get();
    }

    private static <E extends LivingEntity> boolean cannotReachTarget(E entity) {
        Optional time = entity.m_6274_().m_21952_(MemoryModuleType.f_26326_);
        return time.isPresent() && entity.f_19853_.m_46467_() - (Long)time.get() > 200L;
    }

    private boolean isAttackTargetDead(E entity) {
        Optional target = entity.m_6274_().m_21952_(MemoryModuleType.f_26372_);
        return target.isPresent() && !((LivingEntity)target.get()).m_6084_();
    }

    protected void forgetAttackTarget(E entity) {
        this.forgetCallback.accept(entity, this.getAttackTarget(entity));
        entity.m_6274_().m_21936_(MemoryModuleType.f_26372_);
    }
}

