/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.client.animation.api;

import com.cursedcauldron.wildbackport.client.animation.api.Animation;
import com.cursedcauldron.wildbackport.client.animation.api.AnimationHelper;
import com.cursedcauldron.wildbackport.client.animation.api.AnimationState;
import com.cursedcauldron.wildbackport.core.mixin.access.ModelPartAccessor;
import com.mojang.math.Vector3f;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AnimatedModel<E extends Entity>
extends HierarchicalModel<E> {
    private static final Vector3f CACHE = new Vector3f();

    public AnimatedModel() {
        this(RenderType::m_110458_);
    }

    public AnimatedModel(Function<ResourceLocation, RenderType> function) {
        super(function);
    }

    public Optional<ModelPart> getChild(String name) {
        return this.m_142109_().m_171331_().filter(part -> ((ModelPartAccessor)part).getChildren().containsKey(name)).findFirst().map(part -> part.m_171324_(name));
    }

    protected void animate(AnimationState state, Animation animation, float animationProgress) {
        this.animate(state, animation, animationProgress, 1.0f);
    }

    protected void animate(AnimationState animationState, Animation animation, float animationProgress, float speedMultiplier) {
        animationState.run(animationProgress, speedMultiplier);
        animationState.run(state -> AnimationHelper.animate(this, animation, state.runningTime(), 1.0f, CACHE));
    }
}

