/*
 * Decompiled with CFR 0.152.
 */
package me.pieking1215.waterdripsound;

import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;

public class WaterDripSoundConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    static final ForgeConfigSpec spec = BUILDER.build();

    static void registerClothConfig() {
        ModLoadingContext.get().registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((client, parent) -> {
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)new TranslatableComponent("config.waterdripsound.general"));
            builder.setDefaultBackgroundTexture(new ResourceLocation("minecraft:textures/block/mossy_stone_bricks.png"));
            builder.transparentBackground();
            ConfigEntryBuilder eb = builder.entryBuilder();
            ConfigCategory general = builder.getOrCreateCategory((Component)new TranslatableComponent("key.waterdripsound.category"));
            general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)new TranslatableComponent("config.waterdripsound.enable"), ((Boolean)WaterDripSoundConfig.GENERAL.enabled.get()).booleanValue()).setDefaultValue(true).setSaveConsumer(arg_0 -> WaterDripSoundConfig.GENERAL.enabled.set(arg_0)).build());
            general.addEntry((AbstractConfigListEntry)eb.startIntSlider((Component)new TranslatableComponent("config.waterdripsound.volume"), (int)((Double)WaterDripSoundConfig.GENERAL.volume.get() * 100.0), 0, 100).setDefaultValue(30).setTextGetter(integer -> new TextComponent("Volume: " + integer + "%")).setSaveConsumer(integer -> WaterDripSoundConfig.GENERAL.volume.set((Object)((double)integer.intValue() / 100.0))).build());
            general.addEntry((AbstractConfigListEntry)eb.startIntSlider((Component)new TranslatableComponent("config.waterdripsound.dripChance"), ((Integer)WaterDripSoundConfig.GENERAL.dripChance.get()).intValue(), 1, 100).setDefaultValue(10).setTextGetter(integer -> new TextComponent("One in " + integer)).setSaveConsumer(arg_0 -> WaterDripSoundConfig.GENERAL.dripChance.set(arg_0)).build());
            general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)new TranslatableComponent("config.waterdripsound.useDripstoneSounds"), ((Boolean)WaterDripSoundConfig.GENERAL.useDripstoneSounds.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{new TranslatableComponent("tooltip.config.waterdripsound.useDripstoneSounds")}).setSaveConsumer(arg_0 -> WaterDripSoundConfig.GENERAL.useDripstoneSounds.set(arg_0)).build());
            general.addEntry((AbstractConfigListEntry)eb.startEnumSelector((Component)new TranslatableComponent("config.waterdripsound.soundCategory"), SoundSource.class, (Enum)((SoundSource)WaterDripSoundConfig.GENERAL.soundCategory.get())).setDefaultValue((Enum)SoundSource.AMBIENT).setEnumNameProvider(anEnum -> new TranslatableComponent("soundCategory." + ((SoundSource)anEnum).m_12676_())).setSaveConsumer(arg_0 -> WaterDripSoundConfig.GENERAL.soundCategory.set(arg_0)).build());
            return builder.setSavingRunnable(() -> ((ForgeConfigSpec)spec).save()).build();
        }));
    }

    public static class General {
        public final ForgeConfigSpec.ConfigValue<Boolean> enabled;
        public final ForgeConfigSpec.ConfigValue<Double> volume;
        public final ForgeConfigSpec.ConfigValue<Integer> dripChance;
        public final ForgeConfigSpec.ConfigValue<Boolean> useDripstoneSounds;
        public final ForgeConfigSpec.ConfigValue<SoundSource> soundCategory;

        General(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.enabled = builder.comment("Enables/Disables the whole Mod [false/true|default:true]").translation("enable.waterdripsound.config").define("enableMod", true);
            this.volume = builder.comment("Volume of water/lava drips [0.0-1.0|default:0.3]").translation("volume.waterdripsound.config").define("volume", (Object)0.3);
            this.dripChance = builder.comment("Chance of a drip forming each tick (one in X so lower is faster) [1-100|default:10]").translation("dripChance.waterdripsound.config").define("dripChance", (Object)10);
            this.useDripstoneSounds = builder.comment("If enabled, uses the Dripstone water/lava drip sounds added in 1.17. If not, uses sounds from older versions of the mod. [false/true|default:true]").translation("useDripstoneSounds.waterdripsound.config").define("useDripstoneSounds", true);
            this.soundCategory = builder.comment("Sound category [default:AMBIENT]").translation("soundCategory.waterdripsound.config").define("soundCategory", (Object)SoundSource.AMBIENT);
            builder.pop();
        }
    }
}

