/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.util;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;

public class RenderUtils {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final Font font = RenderUtils.mc.f_91062_;

    public static List<String> trimStringToWidth(String str, int maxWidth) {
        ArrayList<String> trimmedStrings = new ArrayList<String>();
        for (FormattedText text : font.m_92865_().m_92432_(str, maxWidth, Style.f_131099_)) {
            trimmedStrings.add(text.getString());
        }
        return trimmedStrings;
    }

    public static void renderSplitString(PoseStack stack, String string, int x, int y, int wrapWidth, int color) {
        for (String s : RenderUtils.trimStringToWidth(string, wrapWidth)) {
            font.m_92750_(stack, s, (float)x, (float)y, color);
            Objects.requireNonNull(font);
            y += 9;
        }
    }

    public static int getSplitStringWidth(String string, int wrapWidth) {
        List<String> lines = RenderUtils.trimStringToWidth(string, wrapWidth);
        int width = 0;
        for (String line : lines) {
            int stringWidth = font.m_92895_(line);
            if (stringWidth <= width) continue;
            width = stringWidth;
        }
        return width;
    }

    public static int getSplitStringHeight(String string, int wrapWidth) {
        Objects.requireNonNull(font);
        return 9 * RenderUtils.trimStringToWidth(string, wrapWidth).size();
    }

    public static int getRenderWidth(String position, int width) {
        String positionLower = position.toLowerCase();
        if (positionLower.equals("top_left") || positionLower.equals("center_left") || positionLower.equals("bottom_left")) {
            return 10;
        }
        return mc.m_91268_().m_85445_() - width;
    }

    public static int getRenderHeight(String position, int height) {
        String positionLower = position.toLowerCase();
        if (positionLower.equals("top_left") || positionLower.equals("top_right")) {
            return 5;
        }
        if (positionLower.equals("bottom_left") || positionLower.equals("bottom_right")) {
            return mc.m_91268_().m_85446_() - height - 5;
        }
        return mc.m_91268_().m_85446_() / 2 - height / 2;
    }
}

