/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.gui;

import com.chaosthedude.notes.gui.EditNoteScreen;
import com.chaosthedude.notes.gui.NotesButton;
import com.chaosthedude.notes.gui.NotesList;
import com.chaosthedude.notes.gui.NotesListEntry;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SelectNoteScreen
extends Screen {
    private Screen prevScreen;
    private NotesButton newButton;
    private NotesButton selectButton;
    private NotesButton editButton;
    private NotesButton copyButton;
    private NotesButton deleteButton;
    private NotesButton pinButton;
    private NotesButton cancelButton;
    private NotesList selectionList;

    public SelectNoteScreen(Screen prevScreen) {
        super((Component)new TextComponent(I18n.m_118938_((String)"notes.selectNote", (Object[])new Object[0])));
        this.prevScreen = prevScreen;
    }

    public void m_7856_() {
        this.setupButtons();
        this.selectionList = new NotesList(this, this.f_96541_, this.f_96543_ + 110, this.f_96544_, 40, this.f_96544_ - 64, 36);
        this.m_142416_((GuiEventListener)this.selectionList);
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        this.selectionList.m_6305_(stack, mouseX, mouseY, partialTicks);
        SelectNoteScreen.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"notes.selectNote", (Object[])new Object[0]), (int)(this.f_96543_ / 2 + 60), (int)15, (int)0xFFFFFF);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
    }

    public void m_96624_() {
        if (this.selectionList.m_93511_() != null) {
            this.pinButton.m_93666_((Component)(((NotesListEntry)this.selectionList.m_93511_()).isPinned() ? new TranslatableComponent("notes.unpin") : new TranslatableComponent("notes.pin")));
        }
    }

    public void selectNote(NotesListEntry entry) {
        boolean enable;
        this.selectButton.f_93623_ = enable = entry != null;
        this.deleteButton.f_93623_ = enable;
        this.editButton.f_93623_ = enable;
        this.copyButton.f_93623_ = enable;
        this.pinButton.f_93623_ = enable;
    }

    private void setupButtons() {
        this.newButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 40, 110, 20, (Component)new TranslatableComponent("notes.new"), onPress -> this.f_96541_.m_91152_((Screen)new EditNoteScreen(this, null))));
        this.selectButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 65, 110, 20, (Component)new TranslatableComponent("notes.select"), onPress -> {
            NotesListEntry notesEntry = (NotesListEntry)this.selectionList.m_93511_();
            if (notesEntry != null) {
                notesEntry.loadNote();
            }
        }));
        this.editButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 90, 110, 20, (Component)new TranslatableComponent("notes.edit"), onPress -> {
            NotesListEntry notesEntry = (NotesListEntry)this.selectionList.m_93511_();
            if (notesEntry != null) {
                notesEntry.editNote();
            }
        }));
        this.copyButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 115, 110, 20, (Component)new TranslatableComponent("notes.copy"), onPress -> {
            NotesListEntry notesEntry = (NotesListEntry)this.selectionList.m_93511_();
            notesEntry.copyNote();
        }));
        this.deleteButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 140, 110, 20, (Component)new TranslatableComponent("notes.delete"), onPress -> {
            NotesListEntry notesEntry = (NotesListEntry)this.selectionList.m_93511_();
            if (notesEntry != null) {
                notesEntry.deleteNote();
            }
        }));
        this.pinButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 165, 110, 20, (Component)new TranslatableComponent("notes.pin"), onPress -> {
            NotesListEntry notesEntry = (NotesListEntry)this.selectionList.m_93511_();
            notesEntry.togglePin();
        }));
        this.cancelButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, this.f_96544_ - 30, 110, 20, (Component)new TranslatableComponent("gui.cancel"), onPress -> this.f_96541_.m_91152_(this.prevScreen)));
        this.selectButton.f_93623_ = false;
        this.deleteButton.f_93623_ = false;
        this.editButton.f_93623_ = false;
        this.copyButton.f_93623_ = false;
        this.pinButton.f_93623_ = false;
    }
}

