/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.gui;

import com.chaosthedude.notes.util.StringUtils;
import com.chaosthedude.notes.util.WrappedString;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NotesTextField
extends AbstractWidget
implements Widget,
GuiEventListener {
    private static final Minecraft mc = Minecraft.m_91087_();
    private int margin;
    private String text;
    private int topVisibleLine;
    private int bottomVisibleLine;
    private int maxVisibleLines;
    private int wrapWidth;
    private final Font fontRenderer;
    private int cursorCounter;
    private boolean canLoseFocus = true;
    private boolean isEnabled = true;
    private int cursorPos;
    private int selectionPos;
    private int enabledColor = 0xE0E0E0;
    private int disabledColor = 0x707070;

    public NotesTextField(Font fontRenderer, int x, int y, int width, int height, int margin) {
        super(x, y, width, height, (Component)new TextComponent(""));
        this.fontRenderer = fontRenderer;
        this.margin = margin;
        this.text = "";
        Objects.requireNonNull(fontRenderer);
        this.maxVisibleLines = Mth.m_14143_((float)((height - margin * 2) / 9)) - 1;
        this.wrapWidth = width - margin * 2;
        this.selectionPos = -1;
    }

    public boolean m_7933_(int keyCode, int par2, int par3) {
        if (Screen.m_96632_((int)keyCode)) {
            NotesTextField.mc.f_91068_.m_90911_(this.getSelectedText());
        } else if (Screen.m_96628_((int)keyCode)) {
            if (this.getSelectionDifference() != 0) {
                NotesTextField.mc.f_91068_.m_90911_(this.getSelectedText());
                this.deleteSelectedText();
            }
        } else if (Screen.m_96630_((int)keyCode)) {
            this.insert(NotesTextField.mc.f_91068_.m_90876_());
        } else if (this.isKeyComboCtrlBack(keyCode)) {
            this.deletePrevWord();
        } else {
            if (keyCode == 259) {
                if (this.getSelectionDifference() != 0) {
                    this.deleteSelectedText();
                } else {
                    this.deletePrev();
                }
                return true;
            }
            if (keyCode == 261) {
                if (this.getSelectionDifference() != 0) {
                    this.deleteSelectedText();
                } else {
                    this.deleteNext();
                }
                return true;
            }
            if (keyCode == 258) {
                this.insert("    ");
                return true;
            }
            if (keyCode == 335) {
                this.insertNewLine();
                return true;
            }
            if (keyCode == 257) {
                this.insertNewLine();
                return true;
            }
            if (keyCode == 268) {
                this.updateSelectionPos();
                this.setCursorPos(0);
                return true;
            }
            if (keyCode == 269) {
                this.updateSelectionPos();
                this.setCursorPos(this.text.length());
                return true;
            }
            if (keyCode == 265) {
                this.updateSelectionPos();
                this.moveUp();
                return true;
            }
            if (keyCode == 264) {
                this.updateSelectionPos();
                this.moveDown();
                return true;
            }
            if (keyCode == 263) {
                boolean moveLeft = true;
                if (Screen.m_96638_()) {
                    if (this.selectionPos < 0) {
                        this.selectionPos = this.cursorPos;
                    }
                } else {
                    if (this.selectionPos > -1) {
                        this.setCursorPos(this.getSelectionStart());
                        moveLeft = false;
                    }
                    this.selectionPos = -1;
                }
                if (moveLeft) {
                    this.moveLeft();
                }
                return true;
            }
            if (keyCode == 262) {
                boolean moveRight = true;
                if (Screen.m_96638_()) {
                    if (this.selectionPos < 0) {
                        this.selectionPos = this.cursorPos;
                    }
                } else {
                    if (this.selectionPos > -1) {
                        this.setCursorPos(this.getSelectionEnd());
                        moveRight = false;
                    }
                    this.selectionPos = -1;
                }
                if (moveRight) {
                    this.moveRight();
                }
                return true;
            }
        }
        return false;
    }

    public boolean m_5534_(char typedChar, int p_charTyped_2_) {
        if (this.m_93696_() && SharedConstants.m_136188_((char)typedChar)) {
            if (this.isEnabled) {
                this.insert(Character.toString(typedChar));
                this.updateVisibleLines();
            }
            return true;
        }
        return false;
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        int color = 140;
        GuiComponent.m_93172_((PoseStack)stack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)0x46000000);
        this.renderVisibleText(stack);
        this.renderCursor(stack);
        this.renderScrollBar(stack);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        boolean isWithinBounds = this.isWithinBounds(mouseX, mouseY);
        if (this.canLoseFocus) {
            this.m_93692_(isWithinBounds);
        }
        if (this.m_93696_() && isWithinBounds && mouseButton == 0) {
            int relativeMouseX = (int)mouseX - this.f_93620_ - this.margin;
            int relativeMouseY = (int)mouseY - this.f_93621_ - this.margin;
            Objects.requireNonNull(this.fontRenderer);
            int y = Mth.m_14045_((int)(relativeMouseY / 9 + this.topVisibleLine), (int)0, (int)this.getFinalLineIndex());
            int x = this.fontRenderer.m_92837_(this.getLine(y), relativeMouseX, false).length();
            this.setCursorPos(this.countCharacters(y) + x);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int state) {
        boolean isWithinBounds = this.isWithinBounds(mouseX, mouseY);
        if (this.canLoseFocus) {
            this.m_93692_(isWithinBounds);
        }
        if (this.m_93696_() && isWithinBounds && state == 0) {
            int relativeMouseX = (int)mouseX - this.f_93620_ - this.margin;
            int relativeMouseY = (int)mouseY - this.f_93621_ - this.margin;
            Objects.requireNonNull(this.fontRenderer);
            int y = Mth.m_14045_((int)(relativeMouseY / 9 + this.topVisibleLine), (int)0, (int)this.getFinalLineIndex());
            int x = this.fontRenderer.m_92837_(this.getLine(y), relativeMouseX, false).length();
            int pos = Mth.m_14045_((int)(this.countCharacters(y) + x), (int)0, (int)this.text.length());
            if (pos != this.cursorPos) {
                this.selectionPos = this.cursorPos;
                this.setCursorPos(pos);
            } else {
                this.selectionPos = -1;
            }
            return true;
        }
        return false;
    }

    public boolean m_6050_(double par1, double par2, double par3) {
        if (par3 < 0.0) {
            this.incrementVisibleLines();
            return true;
        }
        if (par3 > 0.0) {
            this.decrementVisibleLines();
            return true;
        }
        return false;
    }

    public int m_5711_() {
        return this.f_93618_ - this.margin * 2;
    }

    public void m_93692_(boolean focused) {
        if (focused && !this.m_93696_()) {
            this.cursorCounter = 0;
        }
        super.m_93692_(focused);
    }

    public void tick() {
        ++this.cursorCounter;
    }

    public List<String> toLines() {
        return StringUtils.wrapToWidth(this.text, this.wrapWidth);
    }

    public List<WrappedString> toLinesWithIndication() {
        return StringUtils.wrapToWidthWithIndication(this.text, this.wrapWidth);
    }

    public String getLine(int line) {
        return line >= 0 && line < this.toLines().size() ? this.toLines().get(line) : this.getFinalLine();
    }

    public String getFinalLine() {
        return this.getLine(this.getFinalLineIndex());
    }

    public String getCurrentLine() {
        return this.getLine(this.getCursorY());
    }

    public List<String> getVisibleLines() {
        List<String> lines = this.toLines();
        ArrayList<String> visibleLines = new ArrayList<String>();
        for (int i = this.topVisibleLine; i <= this.bottomVisibleLine; ++i) {
            if (i >= lines.size()) continue;
            visibleLines.add(lines.get(i));
        }
        return visibleLines;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newText) {
        this.text = newText;
        this.updateVisibleLines();
    }

    public int getFinalLineIndex() {
        return this.toLines().size() - 1;
    }

    public boolean cursorIsValid() {
        int y = this.getCursorY();
        return y >= this.topVisibleLine && y <= this.bottomVisibleLine;
    }

    public int getRenderSafeCursorY() {
        return this.getCursorY() - this.topVisibleLine;
    }

    public int getAbsoluteBottomVisibleLine() {
        return this.topVisibleLine + (this.maxVisibleLines - 1);
    }

    public int getCursorWidth(int pos) {
        String line = this.getCurrentLine();
        return this.fontRenderer.m_92895_(line.substring(0, Mth.m_14045_((int)this.getCursorX(), (int)0, (int)line.length())));
    }

    public int getCursorWidth() {
        return this.getCursorWidth(this.cursorPos);
    }

    public boolean isWithinBounds(double mouseX, double mouseY) {
        return mouseX >= (double)this.f_93620_ && mouseX < (double)(this.f_93620_ + this.f_93618_) && mouseY >= (double)this.f_93621_ && mouseY < (double)(this.f_93621_ + this.f_93619_);
    }

    public boolean atBeginningOfLine() {
        return this.getCursorX() == 0;
    }

    public boolean atEndOfLine() {
        return this.getCursorX() == this.getCurrentLine().length();
    }

    public boolean atBeginningOfNote() {
        return this.cursorPos == 0;
    }

    public boolean atEndOfNote() {
        return this.cursorPos >= this.text.length();
    }

    public int getVisibleLineCount() {
        return this.bottomVisibleLine - this.topVisibleLine + 1;
    }

    public void updateVisibleLines() {
        while (this.getVisibleLineCount() <= this.maxVisibleLines && this.bottomVisibleLine < this.getFinalLineIndex()) {
            ++this.bottomVisibleLine;
        }
    }

    public boolean needsScrollBar() {
        return this.toLines().size() > this.getVisibleLineCount();
    }

    public boolean isKeyComboCtrlBack(int keyCode) {
        return keyCode == 259 && Screen.m_96637_() && !Screen.m_96638_() && !Screen.m_96639_();
    }

    public void insert(String newText) {
        this.deleteSelectedText();
        String finalText = StringUtils.insertStringAt(StringUtils.filter(newText), this.text, this.cursorPos);
        this.setText(finalText);
        this.moveCursorPosBy(newText.length());
    }

    public void insertNewLine() {
        this.insert(String.valueOf('\n'));
    }

    private void deleteNext() {
        String currentText = this.text;
        if (!this.atEndOfNote() && !currentText.isEmpty()) {
            StringBuilder sb = new StringBuilder(currentText);
            sb.deleteCharAt(this.cursorPos);
            this.setText(sb.toString());
            --this.selectionPos;
        }
    }

    private void deletePrev() {
        String currentText = this.text;
        if (!this.atBeginningOfNote() && !currentText.isEmpty()) {
            StringBuilder sb = new StringBuilder(currentText);
            sb.deleteCharAt(this.cursorPos - 1);
            this.setText(sb.toString());
            this.moveLeft();
        }
    }

    private void deletePrevWord() {
        block6: {
            if (this.atBeginningOfNote()) break block6;
            char prev = this.text.charAt(this.cursorPos - 1);
            if (prev == ' ') {
                while (prev == ' ') {
                    this.deletePrev();
                    if (this.atBeginningOfNote()) {
                        return;
                    }
                    prev = this.text.charAt(this.cursorPos - 1);
                }
            } else {
                while (prev != ' ') {
                    this.deletePrev();
                    if (this.atBeginningOfNote()) {
                        return;
                    }
                    prev = this.text.charAt(this.cursorPos - 1);
                }
            }
        }
    }

    private void deleteSelectedText() {
        while (this.getSelectionDifference() > 0) {
            this.deletePrev();
        }
        while (this.getSelectionDifference() < 0) {
            this.deleteNext();
        }
        this.selectionPos = -1;
    }

    private void incrementVisibleLines() {
        if (this.bottomVisibleLine < this.getFinalLineIndex()) {
            ++this.topVisibleLine;
            ++this.bottomVisibleLine;
        }
    }

    private void decrementVisibleLines() {
        if (this.topVisibleLine > 0) {
            --this.topVisibleLine;
            --this.bottomVisibleLine;
        }
    }

    private int countCharacters(int maxLineIndex) {
        List<WrappedString> wrappedLines = this.toLinesWithIndication();
        int count = 0;
        for (int i = 0; i < maxLineIndex; ++i) {
            WrappedString wrappedLine = wrappedLines.get(i);
            count += wrappedLine.getText().length();
            if (wrappedLine.isWrapped()) continue;
            ++count;
        }
        return count;
    }

    private int getCursorX(int pos) {
        List<WrappedString> wrappedLines = this.toLinesWithIndication();
        int y = this.getCursorY();
        boolean currentLineIsWrapped = false;
        int count = 0;
        for (int i = 0; i <= y; ++i) {
            if (i >= wrappedLines.size()) continue;
            WrappedString wrappedLine = wrappedLines.get(i);
            if (i < y) {
                count += wrappedLine.getText().length();
                if (!wrappedLine.isWrapped()) {
                    ++count;
                }
            }
            if (!wrappedLine.isWrapped() || i != y || i <= 0) continue;
            currentLineIsWrapped = true;
        }
        if (currentLineIsWrapped) {
            --count;
        }
        return pos - count;
    }

    private int getCursorX() {
        return this.getCursorX(this.cursorPos);
    }

    private int getCursorY(int pos) {
        List<WrappedString> wrappedLines = this.toLinesWithIndication();
        int count = 0;
        for (int i = 0; i < wrappedLines.size(); ++i) {
            WrappedString wrappedLine = wrappedLines.get(i);
            count += wrappedLine.getText().length();
            if (!wrappedLine.isWrapped()) {
                ++count;
            }
            if (count <= pos) continue;
            return i;
        }
        return this.getFinalLineIndex();
    }

    private int getCursorY() {
        return this.getCursorY(this.cursorPos);
    }

    private int getSelectionDifference() {
        return this.selectionPos > -1 ? this.cursorPos - this.selectionPos : 0;
    }

    private boolean hasSelectionOnLine(int line) {
        if (this.selectionPos > -1) {
            List<WrappedString> wrappedLines = this.toLinesWithIndication();
            int count = 0;
            for (int i = 0; i <= line; ++i) {
                WrappedString wrappedLine = wrappedLines.get(i);
                for (int j = 0; j < wrappedLine.getText().length(); ++j) {
                    if (line != i || !this.isInSelection(++count)) continue;
                    return true;
                }
                if (wrappedLine.isWrapped()) continue;
                ++count;
            }
        }
        return false;
    }

    private void setCursorPos(int pos) {
        this.cursorPos = Mth.m_14045_((int)pos, (int)0, (int)this.text.length());
        if (this.getCursorY() > this.bottomVisibleLine) {
            this.incrementVisibleLines();
        } else if (this.getCursorY() < this.topVisibleLine) {
            this.decrementVisibleLines();
        }
    }

    private void moveCursorPosBy(int amount) {
        this.setCursorPos(this.cursorPos + amount);
    }

    private void moveRight() {
        if (!this.atEndOfNote()) {
            this.moveCursorPosBy(1);
        }
    }

    private void moveLeft() {
        if (!this.atBeginningOfNote()) {
            this.moveCursorPosBy(-1);
        }
    }

    private void moveUp() {
        int width = this.getCursorWidth();
        int y = this.getCursorY();
        while (this.cursorPos > 0 && (this.getCursorY() == y || this.getCursorWidth() > width)) {
            this.moveLeft();
        }
    }

    private void moveDown() {
        int width = this.getCursorWidth();
        int y = this.getCursorY();
        while (this.cursorPos < this.text.length() && (this.getCursorY() == y || this.getCursorWidth() < width)) {
            this.moveRight();
        }
    }

    private void updateSelectionPos() {
        if (Screen.m_96638_()) {
            if (this.selectionPos < 0) {
                this.selectionPos = this.cursorPos;
            }
        } else {
            this.selectionPos = -1;
        }
    }

    private boolean isInSelection(int pos) {
        if (this.selectionPos > -1) {
            return pos >= this.getSelectionStart() && pos <= this.getSelectionEnd();
        }
        return false;
    }

    private int getSelectionStart() {
        if (this.selectionPos > -1) {
            if (this.selectionPos > this.cursorPos) {
                return this.cursorPos;
            }
            if (this.cursorPos > this.selectionPos) {
                return this.selectionPos;
            }
        }
        return -1;
    }

    private int getSelectionEnd() {
        if (this.selectionPos > -1) {
            if (this.selectionPos > this.cursorPos) {
                return this.selectionPos;
            }
            if (this.cursorPos > this.selectionPos) {
                return this.cursorPos;
            }
        }
        return -1;
    }

    private String getSelectedText() {
        if (this.getSelectionStart() >= 0 && this.getSelectionEnd() >= 0) {
            return this.text.substring(this.getSelectionStart(), this.getSelectionEnd());
        }
        return "";
    }

    private void drawSelectionBox(int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.f_93620_ + this.f_93618_) {
            endX = this.f_93620_ + this.f_93618_;
        }
        if (startX > this.f_93620_ + this.f_93618_) {
            startX = this.f_93620_ + this.f_93618_;
        }
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69472_();
        RenderSystem.m_69479_();
        RenderSystem.m_69835_((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        builder.m_5483_((double)startX, (double)endY, 0.0).m_5752_();
        builder.m_5483_((double)endX, (double)endY, 0.0).m_5752_();
        builder.m_5483_((double)endX, (double)startY, 0.0).m_5752_();
        builder.m_5483_((double)startX, (double)startY, 0.0).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69462_();
        RenderSystem.m_69493_();
    }

    private void renderSelectionBox(int y, int renderY, String line) {
        if (this.hasSelectionOnLine(y)) {
            int end;
            int start;
            String absoluteLine = this.getLine(y);
            int count = 0;
            List<WrappedString> wrappedLines = this.toLinesWithIndication();
            for (int i = 0; i < y; ++i) {
                WrappedString wrappedLine = wrappedLines.get(i);
                count += wrappedLine.getText().length();
                if (wrappedLine.isWrapped()) continue;
                ++count;
            }
            if (wrappedLines.get(y).isWrapped()) {
                --count;
            }
            if ((start = this.getSelectionStart() - count) < 0) {
                start = 0;
            }
            if ((end = this.getSelectionEnd() - count) > line.length()) {
                end = line.length();
            }
            if (start >= end) {
                this.selectionPos = -1;
            } else {
                String selection = absoluteLine.substring(start, end);
                int startX = this.f_93620_ + this.margin + this.fontRenderer.m_92895_(absoluteLine.substring(0, start));
                int endX = startX + this.fontRenderer.m_92895_(selection);
                Objects.requireNonNull(this.fontRenderer);
                this.drawSelectionBox(startX, renderY, endX, renderY + 9);
            }
        }
    }

    private void renderVisibleText(PoseStack stack) {
        int renderY = this.f_93621_ + this.margin;
        int y = this.topVisibleLine;
        for (String line : this.getVisibleLines()) {
            this.fontRenderer.m_92750_(stack, line, (float)(this.f_93620_ + this.margin), (float)renderY, 0xE0E0E0);
            this.renderSelectionBox(y, renderY, line);
            Objects.requireNonNull(this.fontRenderer);
            renderY += 9;
            ++y;
        }
    }

    private void renderCursor(PoseStack poseStack) {
        boolean shouldDisplayCursor;
        boolean bl = shouldDisplayCursor = this.m_93696_() && this.cursorCounter / 6 % 2 == 0 && this.cursorIsValid();
        if (shouldDisplayCursor) {
            String line = this.getCurrentLine();
            int renderCursorX = this.f_93620_ + this.margin + this.fontRenderer.m_92895_(line.substring(0, Mth.m_14045_((int)this.getCursorX(), (int)0, (int)line.length())));
            int n = this.getRenderSafeCursorY();
            Objects.requireNonNull(this.fontRenderer);
            int renderCursorY = this.f_93621_ + this.margin + n * 9;
            Objects.requireNonNull(this.fontRenderer);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)renderCursorX, (int)(renderCursorY - 1), (int)(renderCursorX + 1), (int)(renderCursorY + 9 + 1), (int)-3092272);
        }
    }

    private void renderScrollBar(PoseStack poseStack) {
        if (this.needsScrollBar()) {
            List<String> lines = this.toLines();
            int effectiveHeight = this.f_93619_ - this.margin / 2;
            int scrollBarHeight = Mth.m_14107_((double)((double)effectiveHeight * ((double)this.getVisibleLineCount() / (double)lines.size())));
            int scrollBarTop = this.f_93621_ + this.margin / 4 + Mth.m_14107_((double)((double)this.topVisibleLine / (double)lines.size() * (double)effectiveHeight));
            int diff = scrollBarTop + scrollBarHeight - (this.f_93621_ + this.f_93619_);
            if (diff > 0) {
                scrollBarTop -= diff;
            }
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.f_93620_ + this.f_93618_ - this.margin * 3 / 4), (int)scrollBarTop, (int)(this.f_93620_ + this.f_93618_ - this.margin / 4), (int)(scrollBarTop + scrollBarHeight), (int)-3092272);
        }
    }

    public void m_142291_(NarrationElementOutput output) {
    }
}

