/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.gui;

import com.chaosthedude.notes.Notes;
import com.chaosthedude.notes.config.ConfigHandler;
import com.chaosthedude.notes.gui.DisplayNoteScreen;
import com.chaosthedude.notes.gui.EditNoteScreen;
import com.chaosthedude.notes.gui.NotesConfirmScreen;
import com.chaosthedude.notes.gui.NotesList;
import com.chaosthedude.notes.gui.SelectNoteScreen;
import com.chaosthedude.notes.note.Note;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NotesListEntry
extends ObjectSelectionList.Entry<NotesListEntry> {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat();
    private final Minecraft mc;
    private final SelectNoteScreen parentScreen;
    private final Note note;
    private final NotesList notesList;
    private long lastClickTime;

    public NotesListEntry(NotesList notesList, Note note) {
        this.notesList = notesList;
        this.note = note;
        this.parentScreen = notesList.getParentScreen();
        this.mc = Minecraft.m_91087_();
    }

    public void m_6311_(PoseStack stack, int par1, int par2, int par3, int par4, int par5, int par6, int par7, boolean par8, float par9) {
        this.mc.f_91062_.m_92883_(stack, this.note.getTitle(), (float)(par3 + 1), (float)(par2 + 1), 0xFFFFFF);
        this.mc.f_91062_.m_92883_(stack, this.note.getScope().format(), (float)(par3 + 4 + this.mc.f_91062_.m_92895_(this.note.getTitle())), (float)(par2 + 1), 0x808080);
        if (this.note.isPinned()) {
            this.mc.f_91062_.m_92883_(stack, I18n.m_118938_((String)"notes.pinned", (Object[])new Object[0]), (float)(par3 + 4 + this.mc.f_91062_.m_92895_(this.note.getTitle()) + this.mc.f_91062_.m_92895_(this.note.getScope().format()) + 4), (float)(par2 + 1), 0xFFFFFF);
        }
        this.mc.f_91062_.m_92883_(stack, this.note.getTitle(), (float)(par3 + 1), (float)(par2 + 1), 0xFFFFFF);
        Font font = this.mc.f_91062_;
        String string = this.note.getPreview(Mth.m_14107_((double)((double)this.notesList.m_5759_() * 0.9)));
        float f = par3 + 1;
        Objects.requireNonNull(this.mc.f_91062_);
        font.m_92883_(stack, string, f, (float)(par2 + 9 + 3), 0x808080);
        Font font2 = this.mc.f_91062_;
        String string2 = this.note.getLastModifiedString();
        float f2 = par3 + 1;
        Objects.requireNonNull(this.mc.f_91062_);
        font2.m_92883_(stack, string2, f2, (float)(par2 + 9 + 14), 0x808080);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int button) {
        if (button == 0) {
            this.notesList.selectNote(this);
            if (Util.m_137550_() - this.lastClickTime < 250L) {
                this.loadNote();
                return true;
            }
            this.lastClickTime = Util.m_137550_();
        }
        return false;
    }

    public void editNote() {
        if (((Boolean)ConfigHandler.CLIENT.useInGameEditor.get()).booleanValue() || !this.note.tryOpenExternal()) {
            this.mc.m_91152_((Screen)new EditNoteScreen(this.parentScreen, this.note));
        }
    }

    public void copyNote() {
        this.note.copy();
        this.notesList.refreshList();
    }

    public void loadNote() {
        this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
        if (((Boolean)ConfigHandler.CLIENT.useInGameViewer.get()).booleanValue() || !this.note.tryOpenExternal()) {
            this.mc.m_91152_((Screen)new DisplayNoteScreen(this.parentScreen, this.note));
        }
    }

    public void togglePin() {
        if (this.isPinned()) {
            Notes.pinnedNote = null;
        } else {
            Notes.pinnedNote = this.note;
            this.mc.m_91152_(null);
        }
    }

    public boolean isPinned() {
        return this.note.equals(Notes.pinnedNote);
    }

    public Note getNote() {
        return this.note;
    }

    public void deleteNote() {
        this.mc.m_91152_((Screen)new NotesConfirmScreen(result -> {
            if (result) {
                this.note.delete();
            }
            this.mc.m_91152_((Screen)this.parentScreen);
        }, (Component)new TextComponent(I18n.m_118938_((String)"notes.confirmDelete", (Object[])new Object[0])), (Component)new TextComponent(this.note.getTitle())));
    }

    public Component m_142172_() {
        return new TextComponent(this.note.getTitle());
    }
}

