/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.gui;

import com.chaosthedude.notes.Notes;
import com.chaosthedude.notes.gui.DisplayNoteScreen;
import com.chaosthedude.notes.gui.NotesButton;
import com.chaosthedude.notes.gui.NotesTextField;
import com.chaosthedude.notes.gui.NotesTitleField;
import com.chaosthedude.notes.note.Note;
import com.chaosthedude.notes.note.Scope;
import com.chaosthedude.notes.util.StringUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EditNoteScreen
extends Screen {
    private final Screen parentScreen;
    private NotesButton saveButton;
    private NotesButton globalButton;
    private NotesButton insertBiomeButton;
    private NotesButton insertChunkButton;
    private NotesButton insertCoordsButton;
    private NotesButton cancelButton;
    private NotesTitleField noteTitleField;
    private NotesTextField noteTextField;
    private String saveDirName;
    private Note note;
    private Scope scope;
    private boolean pinned;

    public EditNoteScreen(Screen parentScreen, @Nullable Note note) {
        super((Component)new TextComponent(note != null ? I18n.m_118938_((String)"notes.editNote", (Object[])new Object[0]) : I18n.m_118938_((String)"notes.newNote", (Object[])new Object[0])));
        this.parentScreen = parentScreen;
        this.note = note != null ? note : new Note("New Note", "", Scope.getCurrentScope());
        this.scope = Scope.getCurrentScope();
        this.pinned = this.note.isPinned();
    }

    public void m_7856_() {
        this.f_96541_.f_91068_.m_90926_(true);
        this.setupTextFields();
        this.setupButtons();
    }

    public void m_96624_() {
        this.noteTitleField.m_94120_();
        this.noteTextField.tick();
        this.insertChunkButton.f_93623_ = this.insertCoordsButton.f_93623_ = this.noteTextField.m_93696_();
        this.insertBiomeButton.f_93623_ = this.insertCoordsButton.f_93623_;
    }

    public void m_7379_() {
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public boolean m_7933_(int keyCode, int par2, int par3) {
        boolean ret = super.m_7933_(keyCode, par2, par3);
        this.updateNote();
        return ret;
    }

    public boolean m_7920_(int keyCode, int par2, int par3) {
        boolean ret = super.m_7920_(keyCode, par2, par3);
        this.updateNote();
        return ret;
    }

    public void m_7522_(GuiEventListener listener) {
        super.m_7522_(listener);
        if (listener != this.noteTextField && this.noteTextField != null) {
            this.noteTextField.m_93692_(false);
        }
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        EditNoteScreen.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)this.f_96539_.getString(), (int)(this.f_96543_ / 2 + 60), (int)15, (int)0xFFFFFF);
        EditNoteScreen.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"notes.saveAs", (Object[])new Object[]{this.note.getUncollidingSaveName(this.note.getTitle())}), (int)(this.f_96543_ / 2 + 55), (int)65, (int)0x808080);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
    }

    private void setupButtons() {
        this.saveButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 40, 110, 20, (Component)new TranslatableComponent("notes.save"), onPress -> {
            this.updateNote();
            this.note.save();
            this.f_96541_.m_91152_((Screen)new DisplayNoteScreen(this.parentScreen, this.note));
            if (this.pinned) {
                Notes.pinnedNote = this.note;
            }
        }));
        this.globalButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 65, 110, 20, (Component)new TextComponent(I18n.m_118938_((String)"notes.global", (Object[])new Object[0]) + ": " + (this.note.getScope() == Scope.GLOBAL ? I18n.m_118938_((String)"notes.on", (Object[])new Object[0]) : I18n.m_118938_((String)"notes.off", (Object[])new Object[0]))), onPress -> {
            this.scope = this.scope == Scope.GLOBAL ? Scope.getCurrentScope() : Scope.GLOBAL;
            this.globalButton.m_93666_((Component)new TextComponent(I18n.m_118938_((String)"notes.global", (Object[])new Object[0]) + (this.scope == Scope.GLOBAL ? ": " + I18n.m_118938_((String)"notes.on", (Object[])new Object[0]) : ": " + I18n.m_118938_((String)"notes.off", (Object[])new Object[0]))));
            this.updateNote();
        }));
        this.insertBiomeButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 90, 110, 20, (Component)new TranslatableComponent("notes.biome"), onPress -> this.insertBiome()));
        this.insertChunkButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 115, 110, 20, (Component)new TranslatableComponent("notes.chunk"), onPress -> this.insertChunk()));
        this.insertCoordsButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 140, 110, 20, (Component)new TranslatableComponent("notes.coordinates"), onPress -> this.insertCoords()));
        this.cancelButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, this.f_96544_ - 30, 110, 20, (Component)new TranslatableComponent("gui.cancel"), onPress -> this.f_96541_.m_91152_(this.parentScreen)));
        this.insertBiomeButton.f_93623_ = false;
        this.insertChunkButton.f_93623_ = false;
        this.insertCoordsButton.f_93623_ = false;
    }

    private void setupTextFields() {
        this.noteTitleField = (NotesTitleField)this.m_142416_((GuiEventListener)new NotesTitleField(this.f_96547_, 130, 40, this.f_96543_ - 140, 20, (Component)new TextComponent("")));
        this.noteTitleField.m_94144_(this.note.getTitle());
        this.m_142416_((GuiEventListener)this.noteTitleField);
        this.noteTitleField.m_5755_(true);
        this.noteTitleField.m_93692_(true);
        this.m_7522_((GuiEventListener)this.noteTitleField);
        this.noteTextField = (NotesTextField)this.m_142416_(new NotesTextField(this.f_96547_, 130, 85, this.f_96543_ - 140, this.f_96544_ - 95, 5));
        this.noteTextField.setText(this.note.getFilteredText());
        this.m_142416_(this.noteTextField);
    }

    private void updateNote() {
        this.note.setTitle(this.noteTitleField.m_94155_());
        this.note.setText(this.noteTextField.getText());
        this.note.setScope(this.scope);
    }

    private void insertBiome() {
        this.noteTextField.insert(StringUtils.fixBiomeName((Level)this.f_96541_.f_91073_, (Biome)this.f_96541_.f_91073_.m_204166_(this.f_96541_.f_91074_.m_142538_()).m_203334_()));
    }

    private void insertChunk() {
        this.noteTextField.insert(this.f_96541_.f_91074_.m_146902_().f_45578_ + ", " + this.f_96541_.f_91074_.m_146902_().f_45579_);
    }

    private void insertCoords() {
        this.noteTextField.insert(this.f_96541_.f_91074_.m_146903_() + ", " + this.f_96541_.f_91074_.m_146904_() + ", " + this.f_96541_.f_91074_.m_146907_());
    }
}

