/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky77.system;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class SystemRegister {
    public static RegistryObject<Block> register(DeferredRegister<Block> deferredBLOCK, String name, Block block) {
        return SystemRegister.register(deferredBLOCK, null, name, block, null);
    }

    public static RegistryObject<Block> register(DeferredRegister<Block> deferredBLOCK, DeferredRegister<Item> deferredITEM, String name, Block block, CreativeModeTab CreativeModeTab2) {
        if (CreativeModeTab2 != null) {
            deferredITEM.register(name, () -> new BlockItem(block, new Item.Properties().m_41491_(CreativeModeTab2)));
        }
        return deferredBLOCK.register(name, () -> block);
    }

    public static RegistryObject<Item> register(DeferredRegister<Item> deferred, String name, Item item) {
        return deferred.register(name, () -> item);
    }

    public static RegistryObject<SoundEvent> register(DeferredRegister<SoundEvent> deferred, String name, SoundEvent sound) {
        return deferred.register(name, () -> sound);
    }

    public static RegistryObject<EntityType<?>> register(DeferredRegister<EntityType<?>> deferred, String name, EntityType entity) {
        return deferred.register(name, () -> entity);
    }

    public static RegistryObject<StructureFeature<JigsawConfiguration>> register(DeferredRegister<StructureFeature<?>> deferred, String name, StructureFeature<JigsawConfiguration> structure) {
        return deferred.register(name, () -> structure);
    }

    public static RegistryObject<?> register(DeferredRegister<RecipeSerializer<?>> deferred, String name, RecipeSerializer<?> recipe) {
        return deferred.register(name, () -> recipe);
    }

    public static <T extends Recipe<?>> RecipeType<T> register(final String key) {
        return (RecipeType)Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)new ResourceLocation(key), (Object)new RecipeType<T>(){

            public String toString() {
                return key;
            }
        });
    }

    public static Holder<PlacedFeature> buildOreSpawn(String name, BlockState state, int veinSize, int minHeight, int maxHeight, int spawnRate, RuleTest replacables, boolean isRare) {
        List<OreConfiguration.TargetBlockState> TARGETLIST = List.of(OreConfiguration.m_161021_((RuleTest)replacables, (BlockState)state));
        Holder FEATURE = FeatureUtils.m_206488_((String)name, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(TARGETLIST, veinSize));
        return PlacementUtils.m_206509_((String)name, (Holder)FEATURE, isRare ? SystemRegister.commonOrePlacement(spawnRate, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)minHeight), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxHeight))) : SystemRegister.rareOrePlacement(spawnRate, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)minHeight), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxHeight))));
    }

    private static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier modifier) {
        return SystemRegister.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)count), modifier);
    }

    private static List<PlacementModifier> rareOrePlacement(int count, PlacementModifier modifier) {
        return SystemRegister.orePlacement((PlacementModifier)RarityFilter.m_191900_((int)count), modifier);
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier placement, PlacementModifier modifier) {
        return List.of(placement, InSquarePlacement.m_191715_(), modifier, BiomeFilter.m_191561_());
    }
}

