/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.moonlightconfigs;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import nl.enjarai.doabarrelroll.moonlightconfigs.ConfigSpec;
import nl.enjarai.doabarrelroll.moonlightconfigs.ConfigType;
import nl.enjarai.doabarrelroll.moonlightconfigs.forge.ConfigBuilderImpl;
import nl.enjarai.doabarrelroll.util.Value;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ConfigBuilder {
    public static final Logger LOGGER = LogManager.getLogger();
    protected final Map<String, String> comments = new HashMap<String, String>();
    private String currentComment;
    private String currentKey;
    protected boolean currentlyDescription;
    protected boolean synced;
    protected Runnable changeCallback;
    private final ResourceLocation name;
    protected final ConfigType type;
    public static final Predicate<Object> STRING_CHECK = o -> o instanceof String;
    public static final Predicate<Object> LIST_STRING_CHECK = s -> {
        if (s instanceof List) {
            return ((Collection)s).stream().allMatch(o -> o instanceof String);
        }
        return false;
    };
    public static final Predicate<Object> COLOR_CHECK = s -> {
        try {
            Integer.parseUnsignedInt(((String)s).replace("0x", ""), 16);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    };

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ConfigBuilder create(ResourceLocation name, ConfigType type) {
        void var1_1;
        return ConfigBuilderImpl.create(name, (ConfigType)var1_1);
    }

    public ConfigBuilder(ResourceLocation name, ConfigType type) {
        this.name = name;
        this.type = type;
    }

    public ConfigSpec buildAndRegister() {
        ConfigSpec spec = this.build();
        spec.register();
        return spec;
    }

    public abstract ConfigSpec build();

    public ResourceLocation getName() {
        return this.name;
    }

    public abstract ConfigBuilder push(String var1);

    public abstract ConfigBuilder pop();

    public abstract Value<Boolean> define(String var1, boolean var2);

    public abstract Value<Double> define(String var1, double var2, double var4, double var6);

    public abstract Value<Integer> define(String var1, int var2, int var3, int var4);

    public abstract Value<Integer> defineColor(String var1, int var2);

    public abstract Value<String> define(String var1, String var2, Predicate<Object> var3);

    public Value<String> define(String name, String defaultValue) {
        return this.define(name, defaultValue, STRING_CHECK);
    }

    public <T extends String> Value<List<String>> define(String name, List<? extends T> defaultValue) {
        return this.define(name, defaultValue, (Object s) -> true);
    }

    protected abstract String currentCategory();

    public abstract <T extends String> Value<List<String>> define(String var1, List<? extends T> var2, Predicate<Object> var3);

    public abstract <V extends Enum<V>> Value<V> define(String var1, V var2);

    public abstract <T> Supplier<List<? extends T>> defineForgeList(String var1, List<? extends T> var2, Predicate<Object> var3);

    public Component description(String name) {
        return new TranslatableComponent(this.translationKey(name));
    }

    public Component tooltip(String name) {
        return new TranslatableComponent(this.tooltipKey(name));
    }

    public String tooltipKey(String name) {
        return "config." + this.name.m_135827_() + "." + this.currentCategory() + "." + name + ".description";
    }

    public String translationKey(String name) {
        return "config." + this.name.m_135827_() + "." + this.currentCategory() + "." + name;
    }

    public String categoryTranslationKey(String name) {
        return "config." + this.name.m_135827_() + "." + name;
    }

    public ConfigBuilder comment(String comment) {
        this.currentComment = comment;
        if (this.currentComment != null && this.currentKey != null) {
            this.comments.put(this.currentKey, this.currentComment);
            this.currentComment = null;
            this.currentKey = null;
        }
        return this;
    }

    public ConfigBuilder withDescription() {
        this.currentlyDescription = true;
        return this;
    }

    public ConfigBuilder setSynced() {
        if (this.type == ConfigType.CLIENT) {
            throw new UnsupportedOperationException("Config syncing cannot be used for client config as its not needed");
        }
        this.synced = true;
        return this;
    }

    public ConfigBuilder onChange(Runnable callback) {
        this.changeCallback = callback;
        return this;
    }

    protected void maybeAddTranslationString(String name) {
        this.currentKey = this.tooltipKey(name);
        if (this.currentComment != null && this.currentKey != null) {
            this.comments.put(this.currentKey, this.currentComment);
            this.currentComment = null;
            this.currentKey = null;
        }
    }

    public static String getReadableName(String name) {
        return Arrays.stream(name.replace(":", "_").split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }
}

