/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.api.net;

import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import nl.enjarai.doabarrelroll.DoABarrelRoll;

public class HandshakeServer<T> {
    private final Supplier<T> configSupplier;
    private final Function<T, String> configSerializer;
    private final Map<ServerPlayer, HandshakeState> syncStates = new WeakHashMap<ServerPlayer, HandshakeState>();

    public HandshakeServer(Supplier<T> configSupplier, Function<T, String> configSerializer) {
        this.configSupplier = configSupplier;
        this.configSerializer = configSerializer;
    }

    public HandshakeState getHandshakeState(ServerPlayer player) {
        return this.syncStates.getOrDefault(player, HandshakeState.NOT_SENT);
    }

    public FriendlyByteBuf getConfigSyncBuf(ServerPlayer player) {
        this.syncStates.put(player, HandshakeState.SENT);
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130070_(this.configSerializer.apply(this.configSupplier.get()));
        return buf;
    }

    public HandshakeState clientReplied(ServerPlayer player, FriendlyByteBuf buf) {
        HandshakeState state = this.getHandshakeState(player);
        if (state == HandshakeState.SENT) {
            if (buf.readBoolean()) {
                this.syncStates.put(player, HandshakeState.ACCEPTED);
                DoABarrelRoll.LOGGER.info("Client of {} accepted server config.", (Object)player.m_7755_().getString());
                return HandshakeState.ACCEPTED;
            }
            this.syncStates.put(player, HandshakeState.FAILED);
            DoABarrelRoll.LOGGER.warn("Client of {} failed to process server config, check client logs find what went wrong.", (Object)player.m_7755_().getString());
            return HandshakeState.FAILED;
        }
        return state;
    }

    public void playerDisconnected(ServerPlayer player) {
        this.syncStates.remove(player);
    }

    public static enum HandshakeState {
        NOT_SENT,
        SENT,
        ACCEPTED,
        FAILED;

    }
}

