/*
 * Decompiled with CFR 0.152.
 */
package net.cursedwarrior.skystructures.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.cursedwarrior.skystructures.world.features.GrassIslandAcaciaFeature;
import net.cursedwarrior.skystructures.world.features.GrassIslandBeesFeature;
import net.cursedwarrior.skystructures.world.features.GrassIslandBirchFeature;
import net.cursedwarrior.skystructures.world.features.GrassIslandBlacksmithFeature;
import net.cursedwarrior.skystructures.world.features.GrassIslandDarkoakFeature;
import net.cursedwarrior.skystructures.world.features.GrassIslandFeature;
import net.cursedwarrior.skystructures.world.features.GrassIslandJungleFeature;
import net.cursedwarrior.skystructures.world.features.GrassIslandOakFeature;
import net.cursedwarrior.skystructures.world.features.GrassIslandSpruceFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class SkyStructuresModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"sky_structures");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> GRASS_ISLAND = SkyStructuresModFeatures.register("grass_island", GrassIslandFeature::feature, new FeatureRegistration(GenerationStep.Decoration.RAW_GENERATION, GrassIslandFeature.GENERATE_BIOMES, GrassIslandFeature::placedFeature));
    public static final RegistryObject<Feature<?>> GRASS_ISLAND_OAK = SkyStructuresModFeatures.register("grass_island_oak", GrassIslandOakFeature::feature, new FeatureRegistration(GenerationStep.Decoration.RAW_GENERATION, GrassIslandOakFeature.GENERATE_BIOMES, GrassIslandOakFeature::placedFeature));
    public static final RegistryObject<Feature<?>> GRASS_ISLAND_SPRUCE = SkyStructuresModFeatures.register("grass_island_spruce", GrassIslandSpruceFeature::feature, new FeatureRegistration(GenerationStep.Decoration.RAW_GENERATION, GrassIslandSpruceFeature.GENERATE_BIOMES, GrassIslandSpruceFeature::placedFeature));
    public static final RegistryObject<Feature<?>> GRASS_ISLAND_BIRCH = SkyStructuresModFeatures.register("grass_island_birch", GrassIslandBirchFeature::feature, new FeatureRegistration(GenerationStep.Decoration.RAW_GENERATION, GrassIslandBirchFeature.GENERATE_BIOMES, GrassIslandBirchFeature::placedFeature));
    public static final RegistryObject<Feature<?>> GRASS_ISLAND_ACACIA = SkyStructuresModFeatures.register("grass_island_acacia", GrassIslandAcaciaFeature::feature, new FeatureRegistration(GenerationStep.Decoration.RAW_GENERATION, GrassIslandAcaciaFeature.GENERATE_BIOMES, GrassIslandAcaciaFeature::placedFeature));
    public static final RegistryObject<Feature<?>> GRASS_ISLAND_JUNGLE = SkyStructuresModFeatures.register("grass_island_jungle", GrassIslandJungleFeature::feature, new FeatureRegistration(GenerationStep.Decoration.RAW_GENERATION, GrassIslandJungleFeature.GENERATE_BIOMES, GrassIslandJungleFeature::placedFeature));
    public static final RegistryObject<Feature<?>> GRASS_ISLAND_DARKOAK = SkyStructuresModFeatures.register("grass_island_darkoak", GrassIslandDarkoakFeature::feature, new FeatureRegistration(GenerationStep.Decoration.RAW_GENERATION, GrassIslandDarkoakFeature.GENERATE_BIOMES, GrassIslandDarkoakFeature::placedFeature));
    public static final RegistryObject<Feature<?>> GRASS_ISLAND_BEES = SkyStructuresModFeatures.register("grass_island_bees", GrassIslandBeesFeature::feature, new FeatureRegistration(GenerationStep.Decoration.RAW_GENERATION, GrassIslandBeesFeature.GENERATE_BIOMES, GrassIslandBeesFeature::placedFeature));
    public static final RegistryObject<Feature<?>> GRASS_ISLAND_BLACKSMITH = SkyStructuresModFeatures.register("grass_island_blacksmith", GrassIslandBlacksmithFeature::feature, new FeatureRegistration(GenerationStep.Decoration.RAW_GENERATION, GrassIslandBlacksmithFeature.GENERATE_BIOMES, GrassIslandBlacksmithFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

