/*
 * Decompiled with CFR 0.152.
 */
package dlovin.smalls.campchair.core.entities;

import dlovin.smalls.campchair.core.blocks.CampChairBlock;
import dlovin.smalls.campchair.core.init.EntityInit;
import dlovin.smalls.campchair.utils.BlockStateUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class SitingEntity
extends Entity {
    protected BlockPos source;
    public boolean reg = false;

    public SitingEntity(Level level) {
        super((EntityType)EntityInit.SEAT.get(), level);
        this.f_19794_ = true;
    }

    protected SitingEntity(Level level, BlockPos source, Vec3 pos, boolean reg) {
        this(level);
        this.source = source;
        this.m_146884_(pos);
        this.reg = reg;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.source == null) {
            this.source = this.m_142538_();
            this.reg = BlockStateUtils.checkForCampfire(this.f_19853_, this.source);
        }
        if (!this.f_19853_.f_46443_) {
            Entity passenger;
            if (this.reg && (passenger = this.m_146895_()) instanceof Player) {
                ((Player)passenger).m_5634_(0.0125f);
            }
            if (this.m_20197_().isEmpty() || !(this.f_19853_.m_8055_(this.source).m_60734_() instanceof CampChairBlock)) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                this.f_19853_.m_46717_(this.m_142538_(), this.f_19853_.m_8055_(this.m_142538_()).m_60734_());
            }
        }
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public double m_6048_() {
        return -0.375;
    }

    public BlockPos getSource() {
        return this.source;
    }

    protected boolean m_7341_(Entity entity) {
        return true;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static void update(Level level, BlockPos source, boolean rest) {
        List seats;
        if (!level.m_5776_() && !(seats = level.m_45976_(SitingEntity.class, new AABB((double)source.m_123341_(), (double)source.m_123342_(), (double)source.m_123343_(), (double)source.m_123341_() + 1.0, (double)source.m_123342_() + 1.0, (double)source.m_123343_() + 1.0))).isEmpty()) {
            boolean flag = BlockStateUtils.checkForCampfire(level, source);
            seats.forEach(s -> {
                s.reg = flag;
                if (rest && flag && s.m_146895_() instanceof Player) {
                    ((Player)s.m_146895_()).m_7166_(Stats.f_12988_.m_12902_((Object)Stats.f_12992_));
                }
            });
        }
    }

    public static InteractionResult create(Level level, BlockPos source, Vec3 pos, Player player, boolean reg, boolean rest) {
        List seats;
        if (!level.m_5776_() && (seats = level.m_45976_(SitingEntity.class, new AABB((double)source.m_123341_(), (double)source.m_123342_(), (double)source.m_123343_(), (double)source.m_123341_() + 1.0, (double)source.m_123342_() + 1.0, (double)source.m_123343_() + 1.0))).isEmpty()) {
            SitingEntity seat = new SitingEntity(level, source, pos, reg);
            level.m_7967_((Entity)seat);
            player.m_7998_((Entity)seat, false);
            if (rest) {
                player.m_7166_(Stats.f_12988_.m_12902_((Object)Stats.f_12992_));
            }
        }
        return InteractionResult.SUCCESS;
    }
}

