/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines.block;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.block.LaserContainer;
import mcjty.deepresonance.modules.machines.block.LensBlock;
import mcjty.deepresonance.modules.machines.data.InfusingBonus;
import mcjty.deepresonance.modules.machines.data.InfusionBonusRegistry;
import mcjty.deepresonance.modules.machines.util.config.LaserConfig;
import mcjty.deepresonance.modules.tank.blocks.TankTileEntity;
import mcjty.deepresonance.util.LiquidCrystalData;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.OrientationTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class LaserTileEntity
extends TickingTileEntity {
    public static final IntegerProperty COLOR = IntegerProperty.m_61631_((String)"color", (int)0, (int)3);
    public static final int SLOT_CRYSTAL = 0;
    public static final int SLOT_CATALYST = 1;
    private static final int SLOT_ACTIVE_CATALYST = 2;
    private int tickCounter = 10;
    private int progressCounter = 0;
    @GuiValue
    private float crystalLiquid = 0.0f;
    private int color = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(3).slot(SlotDefinition.generic().in().out(), 0, 154, 48).slot(SlotDefinition.generic().in().out(), 1, 21, 8).slot(SlotDefinition.generic().out(), 2, 21, 48).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> {
        if (slot == 0) {
            return LaserTileEntity.isCrystalItem(stack.m_41720_());
        }
        if (slot == 1) {
            return !LaserTileEntity.isCrystalItem(stack.m_41720_());
        }
        return false;
    }).insertable(GenericItemHandler.notslot((int)2)).extractable(GenericItemHandler.yes()).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)LaserConfig.POWER_MAXIMUM.get()).intValue(), (long)((Integer)LaserConfig.POWER_PER_TICK_IN.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Laser").containerSupplier((windowId, player) -> new LaserContainer((Supplier<MenuType<GenericContainer>>)MachinesModule.LASER_CONTAINER, (int)windowId, (Supplier<ContainerFactory>)CONTAINER_FACTORY, (GenericTileEntity)this, (Player)player)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));

    public LaserTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MachinesModule.TYPE_LASER.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(LaserTileEntity::new).info(new InfoLine[]{TooltipBuilder.key((String)"message.deepresonance.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()})){

            public RotationType getRotationType() {
                return RotationType.HORIZROTATION;
            }

            protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
                super.m_7926_(builder);
                builder.m_61104_(new Property[]{COLOR});
            }
        };
    }

    private static boolean isCrystalItem(Item item) {
        return item == CoreModule.RESONATING_CRYSTAL_GENERATED_ITEM.get() || item == CoreModule.RESONATING_CRYSTAL_GENERATED_EMPTY_ITEM.get() || item == CoreModule.RESONATING_CRYSTAL_NATURAL_ITEM.get() || item == CoreModule.RESONATING_CRYSTAL_NATURAL_EMPTY_ITEM.get();
    }

    protected void tickServer() {
        --this.tickCounter;
        if (this.tickCounter > 0) {
            return;
        }
        this.tickCounter = 10;
        this.checkCrystal();
        if (this.powerLevel == 0) {
            this.changeColor(0);
            return;
        }
        ItemStack stack = this.items.getStackInSlot(1);
        InfusingBonus bonus = LaserTileEntity.getInfusingBonus(stack);
        if (bonus == null) {
            this.changeColor(0);
            return;
        }
        if (this.getCurrentPower() < (Integer)LaserConfig.RFUSE_PER_CATALYST.get()) {
            this.changeColor(0);
            return;
        }
        if (this.crystalLiquid < (float)((Integer)LaserConfig.CRYSTAL_LIQUID_PER_CATALYST.get()).intValue()) {
            this.changeColor(0);
            return;
        }
        BlockPos tankCoordinate = this.findLens();
        if (tankCoordinate == null) {
            this.changeColor(0);
            return;
        }
        this.changeColor(bonus.color());
        --this.progressCounter;
        this.m_6596_();
        if (this.progressCounter > 0) {
            return;
        }
        this.progressCounter = (Integer)LaserConfig.TICKS10_PER_CATALYST.get();
        this.infuseLiquid(tankCoordinate, bonus);
    }

    public static InfusingBonus getInfusingBonus(ItemStack item) {
        if (item.m_41619_()) {
            return null;
        }
        return InfusionBonusRegistry.getInfusionBonus(item);
    }

    private boolean validRCLTank(TankTileEntity tank) {
        return tank.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).map(handler -> LiquidCrystalData.isLiquidCrystal(handler.getFluidInTank(0).getFluid())).orElse(false);
    }

    private BlockPos findLens() {
        if (!LevelTools.isLoaded((Level)this.f_58857_, (BlockPos)this.f_58858_)) {
            return null;
        }
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        Direction direction = OrientationTools.getOrientationHoriz((BlockState)state);
        BlockPos shouldBeAir = this.f_58858_.m_142300_(direction);
        if (!this.f_58857_.m_8055_(shouldBeAir).m_60795_()) {
            return null;
        }
        BlockPos shouldBeLens = shouldBeAir.m_142300_(direction);
        Block lensBlock = this.f_58857_.m_8055_(shouldBeLens).m_60734_();
        if (!(lensBlock instanceof LensBlock)) {
            return null;
        }
        Direction lensDirection = OrientationTools.getOrientationHoriz((BlockState)this.f_58857_.m_8055_(shouldBeLens));
        if (lensDirection != direction) {
            return null;
        }
        return shouldBeLens.m_142300_(direction);
    }

    private void infuseLiquid(BlockPos tankCoordinate, InfusingBonus bonus) {
        TankTileEntity tank;
        this.items.decrStackSize(1, 1);
        this.energyStorage.consumeEnergy((long)((Integer)LaserConfig.RFUSE_PER_CATALYST.get()).intValue());
        this.crystalLiquid -= (float)((Integer)LaserConfig.CRYSTAL_LIQUID_PER_CATALYST.get()).intValue();
        BlockEntity te = this.f_58857_.m_7702_(tankCoordinate);
        if (te instanceof TankTileEntity && this.validRCLTank(tank = (TankTileEntity)te)) {
            tank.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(handler -> {
                FluidStack stack = handler.drain(10000, IFluidHandler.FluidAction.SIMULATE);
                if (!stack.isEmpty()) {
                    stack = handler.drain(10000, IFluidHandler.FluidAction.EXECUTE);
                    LiquidCrystalData fluidData = LiquidCrystalData.fromStack(stack);
                    float factor = (float)((Integer)LaserConfig.RCL_PER_CATALYST.get()).intValue() / (float)stack.getAmount();
                    float purity = bonus.purityModifier().modify(fluidData.getPurity(), fluidData.getQuality(), (double)factor);
                    float strength = bonus.strengthModifier().modify(fluidData.getStrength(), fluidData.getQuality(), (double)factor);
                    float efficiency = bonus.efficiencyModifier().modify(fluidData.getEfficiency(), fluidData.getQuality(), (double)factor);
                    fluidData.setPurity(purity);
                    fluidData.setStrength(strength);
                    fluidData.setEfficiency(efficiency);
                    FluidStack newStack = fluidData.getFluidStack();
                    if ((double)Math.abs(purity) < 0.01) {
                        newStack.setAmount(newStack.getAmount() - 200);
                        if (newStack.getAmount() < 0) {
                            newStack.setAmount(0);
                        }
                    }
                    if (newStack.getAmount() > 0) {
                        handler.fill(newStack, IFluidHandler.FluidAction.EXECUTE);
                    }
                }
            });
        }
    }

    private void changeColor(int newcolor) {
        if (newcolor != this.color) {
            int mcolor = this.color = newcolor;
            if (this.color == 4) {
                mcolor = 2;
            } else if (this.color == 0) {
                mcolor = 0;
            }
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)COLOR, (Comparable)Integer.valueOf(mcolor)), 3);
            this.m_6596_();
        }
    }

    public int getColor() {
        return this.color;
    }

    private void checkCrystal() {
        ItemStack stack = this.items.getStackInSlot(0);
        if (!stack.m_41619_()) {
            CompoundTag tagCompound = stack.m_41784_().m_128469_("BlockEntityTag");
            float strength = tagCompound.m_128441_("strength") ? tagCompound.m_128457_("strength") / 100.0f : 0.0f;
            int toAdd = (int)((float)((Integer)LaserConfig.MIN_CRYSTAL_LIQUID_PER_CRYSTAL.get()).intValue() + strength * (float)((Integer)LaserConfig.MAX_CRYSTAL_LIQUID_PER_CRYSTAL.get() - (Integer)LaserConfig.MIN_CRYSTAL_LIQUID_PER_CRYSTAL.get()));
            float amt = this.crystalLiquid + (float)toAdd;
            if (amt > (float)((Integer)LaserConfig.CRYSTAL_LIQUID_MAXIMUM.get()).intValue()) {
                return;
            }
            stack.m_41774_(1);
            this.crystalLiquid = amt;
            this.m_6596_();
        }
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        tagCompound.m_128405_("progress", this.progressCounter);
        super.m_183515_(tagCompound);
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        this.getOrCreateInfo(tagCompound).m_128350_("liquid", this.crystalLiquid);
    }

    public void m_142466_(CompoundTag tagCompound) {
        this.progressCounter = tagCompound.m_128451_("progress");
        super.m_142466_(tagCompound);
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.crystalLiquid = info.m_128457_("liquid");
    }

    public int getMaxPower() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getCurrentPower() {
        return this.energyStorage.getEnergyStored();
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)(this.m_58899_().m_123341_() - 10), (double)(this.m_58899_().m_123342_() - 10), (double)(this.m_58899_().m_123343_() - 10), (double)(this.m_58899_().m_123341_() + 10), (double)(this.m_58899_().m_123342_() + 10), (double)(this.m_58899_().m_123343_() + 10));
    }

    public float getCrystalLiquid() {
        return this.crystalLiquid;
    }
}

