/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.datagen;

import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.generator.GeneratorModule;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.pedestal.PedestalModule;
import mcjty.deepresonance.modules.radiation.RadiationModule;
import mcjty.deepresonance.modules.tank.TankModule;
import mcjty.deepresonance.modules.tank.client.TankTESR;
import mcjty.lib.datagen.BaseBlockStateProvider;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockStates
extends BaseBlockStateProvider {
    private static final ResourceLocation DEFAULT_TOP = new ResourceLocation("deepresonance", "block/machine_top");
    private static final ResourceLocation DEFAULT_SIDE = new ResourceLocation("deepresonance", "block/machine_side");
    private static final ResourceLocation DEFAULT_BOTTOM = new ResourceLocation("deepresonance", "block/machine_bottom");

    public BlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "deepresonance", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.registerCrystalModel();
        this.registerTankModel();
        this.registerGeneratorPart();
        this.simpleBlock((Block)CoreModule.RESONATING_ORE_STONE_BLOCK.get());
        this.simpleBlock((Block)CoreModule.RESONATING_ORE_DEEPSLATE_BLOCK.get());
        this.simpleBlock((Block)CoreModule.RESONATING_ORE_NETHER_BLOCK.get());
        this.simpleBlock((Block)CoreModule.RESONATING_ORE_END_BLOCK.get());
        this.simpleBlock((Block)RadiationModule.POISONED_DIRT_BLOCK.get());
        this.simpleBlock((Block)RadiationModule.DENSE_GLASS_BLOCK.get());
        this.simpleBlock((Block)RadiationModule.DENSE_OBSIDIAN_BLOCK.get());
        this.simpleBlock((Block)CoreModule.RESONATING_PLATE_BLOCK_BLOCK.get());
        this.simpleBlock((Block)MachinesModule.VALVE_BLOCK.get(), (ModelFile)this.models().cubeBottomTop(this.name((Block)MachinesModule.VALVE_BLOCK.get()), new ResourceLocation("deepresonance", "block/valve"), DEFAULT_BOTTOM, DEFAULT_TOP));
        this.horizontalOrientedBlock((Block)MachinesModule.SMELTER_BLOCK.get(), (state, builder) -> {
            if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) {
                builder.modelFile(this.frontBasedModel(this.name(state.m_60734_()) + "_active", new ResourceLocation("deepresonance", "block/smelter_active"), DEFAULT_SIDE, DEFAULT_TOP, DEFAULT_BOTTOM));
            } else {
                builder.modelFile(this.frontBasedModel(this.name(state.m_60734_()), new ResourceLocation("deepresonance", "block/smelter"), DEFAULT_SIDE, DEFAULT_TOP, DEFAULT_BOTTOM));
            }
        });
        this.horizontalOrientedBlock((Block)MachinesModule.PURIFIER_BLOCK.get(), (state, builder) -> builder.modelFile(this.frontBasedModel(this.name(state.m_60734_()), new ResourceLocation("deepresonance", "block/purifier"), DEFAULT_SIDE, DEFAULT_TOP, DEFAULT_BOTTOM)));
        this.horizontalOrientedBlock((Block)MachinesModule.LENS_BLOCK.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("lens_mc", new ResourceLocation("deepresonance", "lens"))).texture("lens_texture", "deepresonance:block/lens")).texture("particle", "deepresonance:block/lens"));
        this.horizontalOrientedBlock((Block)MachinesModule.LASER_BLOCK.get(), (ModelFile)this.createLaserModel());
        this.horizontalOrientedBlock((Block)MachinesModule.CRYSTALLIZER_BLOCK.get(), (ModelFile)this.createCrystallizerModel());
        this.orientedBlock((Block)PedestalModule.PEDESTAL.get(), this.frontBasedModel(this.name((Block)PedestalModule.PEDESTAL.get()), this.modLoc("block/pedestal"), DEFAULT_BOTTOM, DEFAULT_BOTTOM, DEFAULT_BOTTOM));
        this.simpleBlock((Block)GeneratorModule.ENERGY_COLLECTOR_BLOCK.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("energy_collector", new ResourceLocation("deepresonance", "collector"))).texture("collector_texture", "deepresonance:block/energy_collector")).texture("particle", "deepresonance:block/energy_collector"));
        this.horizontalOrientedBlock((Block)GeneratorModule.GENERATOR_CONTROLLER_BLOCK.get(), (state, builder) -> {
            if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) {
                builder.modelFile(this.frontBasedModel(this.name(state.m_60734_()), new ResourceLocation("deepresonance", "block/generator_controller_on"), DEFAULT_SIDE, DEFAULT_TOP, DEFAULT_BOTTOM));
            } else {
                builder.modelFile(this.frontBasedModel(this.name(state.m_60734_()), new ResourceLocation("deepresonance", "block/generator_controller"), DEFAULT_SIDE, DEFAULT_TOP, DEFAULT_BOTTOM));
            }
        });
    }

    private void registerGeneratorPart() {
        this.variantBlock((Block)GeneratorModule.GENERATOR_PART_BLOCK.get(), state -> {
            Object extra = "";
            if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61366_)).booleanValue()) {
                extra = (String)extra + "_up";
            }
            if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61367_)).booleanValue()) {
                extra = (String)extra + "_down";
            }
            if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) {
                extra = (String)extra + "_on";
            }
            ResourceLocation id = new ResourceLocation("deepresonance", "block/generator_part_side" + (String)extra);
            return ((BlockModelBuilder)this.models().cube("generator_part" + (String)extra, DEFAULT_BOTTOM, DEFAULT_TOP, id, id, id, id)).texture("particle", id);
        });
    }

    private void registerTankModel() {
        this.simpleBlock((Block)TankModule.TANK_BLOCK.get(), (ModelFile)this.models().cubeBottomTop("tank", TankTESR.TANK_SIDE, TankTESR.TANK_BOTTOM, TankTESR.TANK_TOP));
    }

    private void registerCrystalModel() {
        ResourceLocation crystal = new ResourceLocation("deepresonance", "crystal");
        ResourceLocation crystalGenerated = new ResourceLocation("deepresonance", "crystal_generated");
        ModelBuilder emptyNatural = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("crystal_empty", crystal)).texture("crystal_texture", "deepresonance:block/empty_crystal")).texture("particle", "deepresonance:block/empty_crystal");
        ModelBuilder emptyGenerated = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("crystal_empty_pure", crystalGenerated)).texture("crystal_texture", "deepresonance:block/empty_crystal")).texture("particle", "deepresonance:block/empty_crystal");
        ModelBuilder fullNatural = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("crystal_full", crystal)).texture("crystal_texture", "deepresonance:block/crystal")).texture("particle", "deepresonance:block/crystal");
        ModelBuilder fullGenerated = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("crystal_full_pure", crystalGenerated)).texture("crystal_texture", "deepresonance:block/crystal")).texture("particle", "deepresonance:block/crystal");
        this.getVariantBuilder((Block)CoreModule.RESONATING_CRYSTAL_GENERATED.get()).forAllStates(arg_0 -> BlockStates.lambda$registerCrystalModel$4((ModelFile)fullGenerated, arg_0));
        this.getVariantBuilder((Block)CoreModule.RESONATING_CRYSTAL_GENERATED_EMPTY.get()).forAllStates(arg_0 -> BlockStates.lambda$registerCrystalModel$5((ModelFile)emptyGenerated, arg_0));
        this.getVariantBuilder((Block)CoreModule.RESONATING_CRYSTAL_NATURAL.get()).forAllStates(arg_0 -> BlockStates.lambda$registerCrystalModel$6((ModelFile)fullNatural, arg_0));
        this.getVariantBuilder((Block)CoreModule.RESONATING_CRYSTAL_NATURAL_EMPTY.get()).forAllStates(arg_0 -> BlockStates.lambda$registerCrystalModel$7((ModelFile)emptyNatural, arg_0));
    }

    public BlockModelBuilder createCrystallizerModel() {
        BlockModelBuilder ret = (BlockModelBuilder)this.models().cube("crystallizer", DEFAULT_BOTTOM, DEFAULT_TOP, new ResourceLocation("deepresonance", "block/crystallizer"), DEFAULT_SIDE, DEFAULT_SIDE, DEFAULT_SIDE);
        ModelBuilder.ElementBuilder elem = ret.element();
        for (Direction direction : Direction.values()) {
            elem = elem.face(direction).cullface(direction).texture("#" + direction.m_122433_()).end();
        }
        ret = (BlockModelBuilder)elem.end();
        ret = (BlockModelBuilder)ret.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 7.0f, 16.0f).face(Direction.UP).texture("#" + Direction.UP.m_122433_()).end().end();
        elem = ret.element().from(16.0f, 16.0f, 16.0f).to(0.0f, 0.0f, 0.0f);
        for (Direction direction : Direction.values()) {
            elem = elem.face(direction.m_122424_()).cullface(Direction.NORTH).texture("#" + Direction.UP.m_122433_()).end();
        }
        return (BlockModelBuilder)((BlockModelBuilder)elem.end()).texture("particle", "deepresonance:block/crystallizer");
    }

    public BlockModelBuilder createLaserModel() {
        ResourceLocation laserTxt = new ResourceLocation("deepresonance", "block/laser");
        ResourceLocation laserBackTxt = new ResourceLocation("deepresonance", "block/laser_back");
        return (BlockModelBuilder)((BlockModelBuilder)this.models().cube("laser", DEFAULT_BOTTOM, DEFAULT_TOP, laserTxt, laserBackTxt, laserBackTxt, laserBackTxt)).texture("particle", laserTxt);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerCrystalModel$7(ModelFile emptyNatural, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        return ConfiguredModel.builder().modelFile(emptyNatural).rotationY((int)((direction.m_122435_() + 180.0f) % 360.0f)).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerCrystalModel$6(ModelFile fullNatural, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        return ConfiguredModel.builder().modelFile(fullNatural).rotationY((int)((direction.m_122435_() + 180.0f) % 360.0f)).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerCrystalModel$5(ModelFile emptyGenerated, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        return ConfiguredModel.builder().modelFile(emptyGenerated).rotationY((int)((direction.m_122435_() + 180.0f) % 360.0f)).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerCrystalModel$4(ModelFile fullGenerated, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        return ConfiguredModel.builder().modelFile(fullGenerated).rotationY((int)((direction.m_122435_() + 180.0f) % 360.0f)).build();
    }
}

