/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.compat.jei.purifier;

import com.mojang.blaze3d.vertex.PoseStack;
import mcjty.deepresonance.compat.jei.purifier.PurifierRecipeWrapper;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.util.config.PurifierConfig;
import mcjty.deepresonance.util.LiquidCrystalData;
import mcjty.lib.varia.ComponentFactory;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class PurifierRecipeCategory
implements IRecipeCategory<PurifierRecipeWrapper> {
    private final IGuiHelper guiHelper;
    private final IDrawable background;
    private final IDrawable slot;
    private final IDrawable arrow;
    private final IDrawable icon;
    public static final ResourceLocation ID = new ResourceLocation("deepresonance", "purifier");

    public PurifierRecipeCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.slot = guiHelper.getSlotDrawable();
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)MachinesModule.PURIFIER_BLOCK.get()));
        this.arrow = guiHelper.createDrawable(new ResourceLocation("deepresonance", "textures/gui/guielements.png"), 144, 0, 16, 16);
        this.background = guiHelper.createBlankDrawable(120, 80);
    }

    public Component getTitle() {
        return ComponentFactory.literal((String)"Deep Resonance Purifier");
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends PurifierRecipeWrapper> getRecipeClass() {
        return PurifierRecipeWrapper.class;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void draw(PurifierRecipeWrapper recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        this.slot.draw(stack, 20, 10);
        this.arrow.draw(stack, 50, 10);
        this.slot.draw(stack, 80, 10);
    }

    public void setIngredients(PurifierRecipeWrapper recipe, IIngredients ingredients) {
        ingredients.setInput((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CoreModule.FILTER_MATERIAL_ITEM.get()));
        ingredients.setOutput((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CoreModule.SPENT_FILTER_ITEM.get()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, PurifierRecipeWrapper recipe, IIngredients ingredients) {
        IGuiItemStackGroup group = recipeLayout.getItemStacks();
        group.init(0, true, 20, 10);
        group.set(0, new ItemStack((ItemLike)CoreModule.FILTER_MATERIAL_ITEM.get()));
        group.init(1, false, 80, 10);
        group.set(1, new ItemStack((ItemLike)CoreModule.SPENT_FILTER_ITEM.get()));
        IGuiFluidStackGroup fluidGroup = recipeLayout.getFluidStacks();
        fluidGroup.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (slotIndex == 0) {
                tooltip.add(ComponentFactory.literal((String)"Purity: X").m_130940_(ChatFormatting.GREEN));
            } else {
                tooltip.add(ComponentFactory.literal((String)"Purity: X + 25%").m_130940_(ChatFormatting.GREEN));
            }
        });
        FluidStack input2 = LiquidCrystalData.makeLiquidCrystalStack((Integer)PurifierConfig.RCL_PER_PURIFY.get(), 1.0f, 0.1f, 0.1f, 0.1f);
        FluidStack output = LiquidCrystalData.makeLiquidCrystalStack((Integer)PurifierConfig.RCL_PER_PURIFY.get(), 1.0f, 0.35f, 0.1f, 0.1f);
        fluidGroup.init(0, true, 13, 35, 30, 30, ((Integer)PurifierConfig.RCL_PER_PURIFY.get()).intValue(), true, null);
        fluidGroup.set(0, input2);
        fluidGroup.init(1, false, 73, 35, 30, 30, ((Integer)PurifierConfig.RCL_PER_PURIFY.get()).intValue(), true, null);
        fluidGroup.set(1, output);
    }
}

