/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.loot;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.sootychimneys.core.ISootyChimney;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class ModLootTables {
    public static final ResourceLocation SOOT_SCRAPING = new ResourceLocation("sootychimneys", "soot_scraping");

    public static List<ItemStack> getSootScrapingLootFor(BlockState state, ServerLevel level) {
        if (!(state.m_60734_() instanceof ISootyChimney)) {
            LogUtils.getLogger().error("Soot Scraping is only for ISootyChimney blocks.");
            return Collections.emptyList();
        }
        String blockId = Objects.requireNonNull(state.m_60734_().getRegistryName()).m_135815_();
        try {
            LootContext lootContext = new LootContext.Builder(level).m_78972_(LootContextParams.f_81461_, (Object)state).m_78975_(LootContextParamSets.f_81410_);
            LootTable table = level.m_142572_().m_129898_().m_79217_(new ResourceLocation(SOOT_SCRAPING + "/" + blockId));
            return table.m_79129_(lootContext);
        }
        catch (Exception ex) {
            LogUtils.getLogger().error("Failed to get 'soot_scraping' loot table for '{}'. - {}", (Object)blockId, (Object)ex.toString());
            return Collections.emptyList();
        }
    }
}

