/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.integration.jei.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ScalableItemStackRenderer
implements IIngredientRenderer<ItemStack> {
    private float xScale;
    private float yScale;
    private float zScale;

    public ScalableItemStackRenderer(float xScale, float yScale, float zScale) {
        this.xScale = xScale;
        this.yScale = yScale;
        this.zScale = zScale;
    }

    public ScalableItemStackRenderer(float scale) {
        this.xScale = scale;
        this.yScale = scale;
        this.zScale = scale;
    }

    public void render(PoseStack stack, ItemStack ingredient) {
        if (ingredient != null) {
            stack.m_85836_();
            stack.m_85837_(0.0, 0.0, 0.0);
            stack.m_85841_(this.xScale, this.yScale, this.zScale);
            ScalableItemStackRenderer.drawItemStack(ingredient, stack, 0, 0, 16.0f, 16.0f, 16.0f);
            stack.m_85849_();
        }
    }

    public int getWidth() {
        return (int)(this.xScale * 16.0f);
    }

    public int getHeight() {
        return (int)(this.yScale * 16.0f);
    }

    public void render(PoseStack stack, int xPosition, int yPosition, @Nullable ItemStack ingredient) {
        stack.m_85836_();
        stack.m_85837_((double)xPosition, (double)yPosition, 0.0);
        this.render(stack, ingredient);
        stack.m_85849_();
    }

    private static void drawItemStack(ItemStack itemStack, PoseStack poseStack, int xOffset, int yOffset, float xScale, float yScale, float zScale) {
        boolean flag;
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        BakedModel bakedModel = itemRenderer.m_174264_(itemStack, (Level)null, (LivingEntity)null, 0);
        Minecraft.m_91087_().f_90987_.m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack stack = RenderSystem.m_157191_();
        stack.m_85836_();
        stack.m_166854_(poseStack.m_85850_().m_85861_());
        stack.m_85837_((double)xOffset, (double)yOffset, (double)(100.0f + itemRenderer.f_115093_));
        stack.m_85837_(8.0, 8.0, 0.0);
        stack.m_85841_(1.0f, -1.0f, 1.0f);
        stack.m_85841_(xScale, yScale, zScale);
        RenderSystem.m_157182_();
        PoseStack posestack1 = new PoseStack();
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = flag = !bakedModel.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        itemRenderer.m_115143_(itemStack, ItemTransforms.TransformType.GUI, false, posestack1, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
        multibuffersource$buffersource.m_109911_();
        RenderSystem.m_69482_();
        if (flag) {
            Lighting.m_84931_();
        }
        stack.m_85849_();
        RenderSystem.m_157182_();
    }

    public List<Component> getTooltip(ItemStack ingredient, TooltipFlag tooltipFlag) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        try {
            return ingredient.m_41651_((Player)player, tooltipFlag);
        }
        catch (LinkageError | RuntimeException e) {
            LogUtils.getLogger().error("Failed to get tooltip: {}", (Object)ingredient, (Object)e);
            return Collections.emptyList();
        }
    }
}

