/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.integration.jei.category;

import io.github.mortuusars.sootychimneys.SootyChimneys;
import io.github.mortuusars.sootychimneys.block.ChimneyBlock;
import io.github.mortuusars.sootychimneys.integration.jei.JeiRecipeTypes;
import io.github.mortuusars.sootychimneys.integration.jei.drawable.ChimneySmokeAnimatedDrawable;
import io.github.mortuusars.sootychimneys.integration.jei.recipe.SootCoveringJeiRecipe;
import io.github.mortuusars.sootychimneys.integration.jei.renderer.ScalableItemStackRenderer;
import io.github.mortuusars.sootychimneys.setup.ModItems;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;

public class SootCoveringRecipeCategory
implements IRecipeCategory<SootCoveringJeiRecipe> {
    public static final ResourceLocation UID = SootyChimneys.resource("soot_scraping");
    public static final int BG_WIDTH = 153;
    public static final int BG_HEIGHT = 65;
    public static final Map<Item, Integer> CHIMNEY_SMOKE_Y_ORIGIN = Map.of((Item)ModItems.BRICK_CHIMNEY.get(), 3, (Item)ModItems.DIRTY_BRICK_CHIMNEY.get(), 3, (Item)ModItems.STONE_BRICK_CHIMNEY.get(), 0, (Item)ModItems.DIRTY_STONE_BRICK_CHIMNEY.get(), 0, (Item)ModItems.TERRACOTTA_CHIMNEY.get(), 10, (Item)ModItems.DIRTY_TERRACOTTA_CHIMNEY.get(), 10, (Item)ModItems.COPPER_CHIMNEY.get(), -1, (Item)ModItems.DIRTY_COPPER_CHIMNEY.get(), -1);
    private final Component title;
    private final IDrawable background;
    private final IDrawableStatic icon;
    private IGuiHelper helper;

    public SootCoveringRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.title = new TranslatableComponent("jei.sootychimneys.category.soot_covering");
        ResourceLocation texture = SootyChimneys.resource("textures/gui/jei/soot_covering.png");
        this.background = helper.createDrawable(texture, 0, 0, 153, 65);
        this.icon = helper.drawableBuilder(SootyChimneys.resource("textures/gui/jei/soot_covering_icon.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SootCoveringJeiRecipe recipe, IFocusGroup focuses) {
        ChimneySmokeAnimatedDrawable ingredientSmoke = new ChimneySmokeAnimatedDrawable(this.helper);
        ChimneySmokeAnimatedDrawable resultSmoke = new ChimneySmokeAnimatedDrawable(this.helper);
        try {
            BlockItem ingredientChimneyBlockItem = (BlockItem)recipe.getIngredientChimney().m_41720_();
            float ingredientChimneySpeed = ((ChimneyBlock)ingredientChimneyBlockItem.m_40614_()).getSmokeProperties().getSpeed();
            float ingredientChimneyIntensity = ((ChimneyBlock)ingredientChimneyBlockItem.m_40614_()).getSmokeProperties().getIntensity();
            BlockItem resultChimneyBlockItem = (BlockItem)recipe.getResultChimney().m_41720_();
            float resultChimneySpeed = ((ChimneyBlock)resultChimneyBlockItem.m_40614_()).getSmokeProperties().getSpeed();
            float resultChimneyIntensity = ((ChimneyBlock)resultChimneyBlockItem.m_40614_()).getSmokeProperties().getIntensity();
            ingredientSmoke.setSpeed(ingredientChimneySpeed);
            ingredientSmoke.setIntensity(ingredientChimneyIntensity);
            resultSmoke.setSpeed(resultChimneySpeed);
            resultSmoke.setIntensity(resultChimneyIntensity);
        }
        catch (Exception ingredientChimneyBlockItem) {
            // empty catch block
        }
        Integer yOffset = CHIMNEY_SMOKE_Y_ORIGIN.get(recipe.getIngredientChimney().m_41720_());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 10, 18).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new ScalableItemStackRenderer(2.5f)).setOverlay((IDrawable)ingredientSmoke, 12, yOffset.intValue()).addItemStack(recipe.getIngredientChimney())).setSlotName("CleanChimney");
        Integer yOffset1 = CHIMNEY_SMOKE_Y_ORIGIN.get(recipe.getResultChimney().m_41720_());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 103, 18).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new ScalableItemStackRenderer(2.5f)).setOverlay((IDrawable)resultSmoke, 12, yOffset1.intValue()).addItemStack(recipe.getResultChimney())).setSlotName("DirtyChimney");
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends SootCoveringJeiRecipe> getRecipeClass() {
        return this.getRecipeType().getRecipeClass();
    }

    public RecipeType<SootCoveringJeiRecipe> getRecipeType() {
        return JeiRecipeTypes.SOOT_COVERING;
    }
}

