/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.data.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.mortuusars.sootychimneys.recipe.ingredient.ChanceResult;
import io.github.mortuusars.sootychimneys.setup.ModRecipeSerializers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public class SootScrapingRecipeBuilder {
    private final List<ChanceResult> results = new ArrayList<ChanceResult>(4);
    private final Ingredient input;
    private final Ingredient tool;

    public SootScrapingRecipeBuilder(Ingredient input, Ingredient tool, ItemLike mainResult, int count, float chance) {
        this.input = input;
        this.tool = tool;
        this.results.add(new ChanceResult(new ItemStack((ItemLike)mainResult.m_5456_(), count), chance));
    }

    public SootScrapingRecipeBuilder addResult(ItemLike result) {
        return this.addResult(result, 1);
    }

    public SootScrapingRecipeBuilder addResult(ItemLike result, int count) {
        this.results.add(new ChanceResult(new ItemStack((ItemLike)result.m_5456_(), count), 1.0f));
        return this;
    }

    public SootScrapingRecipeBuilder addResultWithChance(ItemLike result, float chance) {
        return this.addResultWithChance(result, chance, 1);
    }

    public SootScrapingRecipeBuilder addResultWithChance(ItemLike result, float chance, int count) {
        this.results.add(new ChanceResult(new ItemStack((ItemLike)result.m_5456_(), count), chance));
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumerIn) {
        ResourceLocation location = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.input.m_43908_()[0].m_41720_());
        if (location.toString().equals("minecraft:barrier")) {
            throw new IllegalStateException("Cannot get path from the ingredient: '" + this.input.m_43942_() + "'. Provide custom save path.");
        }
        this.build(consumerIn, location.m_135815_());
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.input.m_43908_()[0].m_41720_());
        ResourceLocation saveLocation = new ResourceLocation("sootychimneys", "soot_scraping/" + save);
        if (saveLocation.equals((Object)resourcelocation)) {
            throw new IllegalStateException("Soot Scraping Recipe '" + save + "' should remove its 'save' argument as it's the same as the default.");
        }
        this.build(consumerIn, saveLocation);
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        this.results.sort((result1, result2) -> result1.getChance() > result2.getChance() ? -1 : 1);
        consumerIn.accept(new Result(id, this.input, this.tool, this.results));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final Ingredient tool;
        private final List<ChanceResult> results;

        public Result(ResourceLocation id, Ingredient ingredient, Ingredient tool, List<ChanceResult> results) {
            this.id = id;
            this.ingredient = ingredient;
            this.tool = tool;
            this.results = results;
        }

        public void m_7917_(JsonObject json) {
            json.add("ingredient", this.ingredient.m_43942_());
            json.add("tool", this.tool.m_43942_());
            JsonArray arrayResults = new JsonArray();
            for (ChanceResult result : this.results) {
                arrayResults.add(result.toJson());
            }
            json.add("results", (JsonElement)arrayResults);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipeSerializers.SOOT_SCRAPING.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

