/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.data;

import io.github.mortuusars.sootychimneys.block.ChimneyBlock;
import io.github.mortuusars.sootychimneys.core.ISootyChimney;
import io.github.mortuusars.sootychimneys.data.BaseLootTableProvider;
import io.github.mortuusars.sootychimneys.setup.ModBlockEntities;
import io.github.mortuusars.sootychimneys.setup.ModBlocks;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.RegistryObject;

public class ModLootTablesProvider
extends BaseLootTableProvider {
    public ModLootTablesProvider(DataGenerator pGenerator) {
        super(pGenerator);
    }

    @Override
    protected void addTables() {
        ModBlocks.CHIMNEYS.forEach((Consumer<RegistryObject<? extends ChimneyBlock>>)((Consumer<RegistryObject>)chimney -> {
            ISootyChimney sootyChimney;
            Block chimneyBlock = (Block)chimney.get();
            String path = Objects.requireNonNull(chimneyBlock.getRegistryName()).m_135815_();
            this.blockLootTables.put(chimneyBlock, this.createStandardTable(path, chimneyBlock, (BlockEntityType)ModBlockEntities.CHIMNEY_BLOCK_ENTITY.get()));
            if (chimneyBlock instanceof ISootyChimney && (sootyChimney = (ISootyChimney)chimneyBlock).isDirty()) {
                this.customLootTables.put(new ResourceLocation("sootychimneys:soot_scraping/" + path), this.createSootLootTable((ItemLike)Items.f_42498_, (NumberProvider)ConstantValue.m_165692_((float)1.0f), sootyChimney.getScrapingDropChance()));
            }
        }));
    }

    private LootTable createSootLootTable(ItemLike itemLike, NumberProvider rolls, float chance) {
        LootPool.Builder pool = LootPool.m_79043_().m_165133_(rolls).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)itemLike)).m_6509_(LootItemRandomChanceCondition.m_81927_((float)chance));
        return LootTable.m_79147_().m_79161_(pool).m_79167_();
    }
}

