/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.core;

import io.github.mortuusars.sootychimneys.config.CommonConfig;
import io.github.mortuusars.sootychimneys.core.TimeOfDay;
import io.github.mortuusars.sootychimneys.core.Weather;
import io.github.mortuusars.sootychimneys.core.Wind;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WindGetter {
    private static final Wind _wind = new Wind(0.0, 0.0f);

    public static Wind getWind() {
        return _wind;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!((Boolean)CommonConfig.WIND_ENABLED.get()).booleanValue()) {
            return;
        }
        Level level = event.player.m_183503_();
        if (level.m_5776_() && level.m_46467_() % 5L == 0L) {
            WindGetter.updateWind(level);
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent event) {
        Level level = event.getWorld();
        event.getPlayer().m_5661_((Component)new TextComponent(_wind + "\nTime of day: " + TimeOfDay.of(level) + "\nWeather: " + Weather.of(level)), true);
    }

    private static void updateWind(Level level) {
        Random random = level.f_46441_;
        double addDegrees = Math.exp(random.nextDouble() * 3.5) * (double)(random.nextBoolean() ? -1 : 1);
        _wind.update(addDegrees, WindGetter.getWindStrengthChange(level));
    }

    private static float getWindStrengthChange(Level level) {
        TimeOfDay timeOfDay = TimeOfDay.of(level);
        Weather weather = Weather.of(level);
        Random random = level.m_5822_();
        if (weather == Weather.THUNDER) {
            return random.nextFloat(-0.1f, 0.11f) + Math.max(0.0f, 0.4f - _wind.getStrength());
        }
        if (weather == Weather.RAIN) {
            return random.nextFloat(-0.08f, 0.09f) + Math.max(0.0f, 0.2f - _wind.getStrength()) - Math.max(0.0f, _wind.getStrength() - 0.6f);
        }
        if (timeOfDay != TimeOfDay.DAY) {
            return random.nextFloat(-0.03f, 0.04f) + Math.max(0.0f, 0.008f - _wind.getStrength()) - Math.max(0.0f, _wind.getStrength() - 0.2f);
        }
        return random.nextFloat(-0.04f, 0.05f) + Math.max(0.0f, 0.008f - _wind.getStrength()) - Math.max(0.0f, _wind.getStrength() - 0.3f);
    }
}

