/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.block;

import com.mojang.math.Vector3f;
import io.github.mortuusars.sootychimneys.block.ChimneyBlockEntity;
import io.github.mortuusars.sootychimneys.config.CommonConfig;
import io.github.mortuusars.sootychimneys.core.ChimneySmokeProperties;
import io.github.mortuusars.sootychimneys.core.ISootyChimney;
import io.github.mortuusars.sootychimneys.core.Wind;
import io.github.mortuusars.sootychimneys.core.WindGetter;
import io.github.mortuusars.sootychimneys.loot.ModLootTables;
import io.github.mortuusars.sootychimneys.setup.ModBlockEntities;
import io.github.mortuusars.sootychimneys.setup.ModTags;
import io.github.mortuusars.sootychimneys.utils.RandomOffset;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChimneyBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty LIT = RedstoneTorchBlock.f_55674_;
    public static final BooleanProperty BLOCKED = BooleanProperty.m_61465_((String)"blocked");
    private final ChimneySmokeProperties smokeProperties;

    public ChimneyBlock(ChimneySmokeProperties smokeProperties, BlockBehaviour.Properties properties) {
        super(properties);
        this.smokeProperties = smokeProperties;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BLOCKED, (Comparable)Boolean.valueOf(false)));
    }

    public ChimneySmokeProperties getSmokeProperties() {
        return this.smokeProperties;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT}).m_61104_(new Property[]{BLOCKED});
    }

    public boolean shouldEmitSmoke(BlockState blockState, Level level, BlockPos pos) {
        return (Boolean)blockState.m_61143_((Property)LIT) != false && (Boolean)blockState.m_61143_((Property)BLOCKED) == false && !level.m_8055_(pos.m_7494_()).m_204336_(ModTags.Blocks.CHIMNEYS);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        boolean newBlockedValue;
        if (!player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            return InteractionResult.PASS;
        }
        boolean bl = newBlockedValue = (Boolean)state.m_61143_((Property)BLOCKED) == false;
        if (level.f_46443_) {
            String messageTranslationKey = "message.sootychimneys." + (newBlockedValue ? "blocked" : "open");
            player.m_5661_((Component)new TranslatableComponent(messageTranslationKey), true);
        } else {
            Vector3f particleOrigin = this.getSmokeProperties().getParticleOrigin();
            Random random = level.m_5822_();
            for (int i = 0; i < random.nextInt(5); ++i) {
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)pos.m_123341_() + particleOrigin.m_122239_()), (double)((float)pos.m_123342_() + particleOrigin.m_122260_()) - 0.1, (double)((float)pos.m_123343_() + particleOrigin.m_122269_()), 1, random.nextGaussian() * 0.1, random.nextGaussian() * 0.1, random.nextGaussian() * 0.1, 0.0);
            }
            level.m_5594_(null, pos, newBlockedValue ? SoundEvents.f_12026_ : SoundEvents.f_12027_, SoundSource.BLOCKS, 0.8f, 0.85f + random.nextFloat() * 0.05f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BLOCKED, (Comparable)Boolean.valueOf(newBlockedValue)), 3);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (pLevel.f_46443_) {
            return;
        }
        boolean hasRedstoneSignal = pLevel.m_46753_(pPos);
        if ((Boolean)pState.m_61143_((Property)LIT) == hasRedstoneSignal) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(!hasRedstoneSignal)), 3);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(!pContext.m_43725_().m_46753_(pContext.m_8083_())));
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (!pLevel.f_46443_) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(!pLevel.m_46753_(pPos))), 2);
        }
    }

    public void emitParticles(Level level, BlockPos pos, BlockState state) {
        Random random = level.m_5822_();
        if (random.nextFloat() > this.getSmokeProperties().getIntensity()) {
            return;
        }
        Vector3f particleOffset = this.getSmokeProperties().getParticleOrigin();
        float x = (float)pos.m_123341_() + particleOffset.m_122239_();
        float y = (float)pos.m_123342_() + particleOffset.m_122260_();
        float z = (float)pos.m_123343_() + particleOffset.m_122269_();
        Wind wind = WindGetter.getWind();
        double windStrengthModifier = (Double)CommonConfig.WIND_STRENGTH_MULTIPLIER.get();
        double xSpeed = wind.getXCoordinate() * (double)wind.getStrength() * windStrengthModifier;
        double zSpeed = wind.getYCoordinate() * (double)wind.getStrength() * windStrengthModifier;
        double ySpeed = 0.05 * (double)this.getSmokeProperties().getSpeed();
        Vector3f particleSpread = this.getSmokeProperties().getParticleSpread();
        int maxParticles = (int)(4.0f * Math.max(this.getSmokeProperties().getIntensity(), 0.5f));
        for (int i = 0; i < random.nextInt(maxParticles); ++i) {
            SimpleParticleType particleType = level.m_8055_(pos.m_7495_()).m_204336_(ModTags.Blocks.CHIMNEYS) ? ParticleTypes.f_123778_ : ParticleTypes.f_123777_;
            level.m_6485_((ParticleOptions)particleType, true, RandomOffset.offset(x, particleSpread.m_122239_(), random), RandomOffset.offset(y, particleSpread.m_122260_(), random), RandomOffset.offset(z, particleSpread.m_122269_(), random), xSpeed, ySpeed, zSpeed);
        }
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new ChimneyBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.m_5776_() && type == ModBlockEntities.CHIMNEY_BLOCK_ENTITY.get() ? ChimneyBlockEntity::particleTick : null;
    }

    public boolean m_6724_(BlockState blockState) {
        ISootyChimney chimney;
        Block block = blockState.m_60734_();
        return block instanceof ISootyChimney && (chimney = (ISootyChimney)block).isClean();
    }

    public void m_7455_(BlockState blockState, ServerLevel level, BlockPos pos, Random random) {
        ISootyChimney sootyChimney;
        Block block = blockState.m_60734_();
        if (block instanceof ISootyChimney && (sootyChimney = (ISootyChimney)block).isClean() && this.shouldEmitSmoke(blockState, (Level)level, pos) && random.nextDouble() < (Double)CommonConfig.DIRTY_CHANCE.get()) {
            level.m_7731_(pos, sootyChimney.getDirtyVariant().m_49966_(), 2);
        }
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        ISootyChimney sootyChimney;
        Block block = state.m_60734_();
        if (toolAction == ToolActions.AXE_SCRAPE && block instanceof ISootyChimney && (sootyChimney = (ISootyChimney)block).isDirty()) {
            sootyChimney.makeSootParticles(context.m_43725_(), context.m_8083_());
            if (!context.m_43725_().f_46443_) {
                ServerLevel level = (ServerLevel)context.m_43725_();
                BlockPos pos = context.m_8083_();
                Vec3i faceNormal = context.m_43719_().m_122436_();
                Vector3f itemSpawnPosition = new Vector3f((float)pos.m_123341_() + 0.5f + (float)faceNormal.m_123341_() * 0.65f, (float)pos.m_123342_() + 0.6f + (float)faceNormal.m_123342_() * 0.65f, (float)pos.m_123343_() + 0.5f + (float)faceNormal.m_123343_() * 0.65f);
                List<ItemStack> items = ModLootTables.getSootScrapingLootFor(state, level);
                this.spawnSootScrapingItems(itemSpawnPosition, level, items);
            }
            return sootyChimney.getCleanVariant().m_152465_(state);
        }
        return null;
    }

    public void spawnSootScrapingItems(Vector3f pos, ServerLevel level, List<ItemStack> items) {
        for (ItemStack itemStack : items) {
            ItemEntity entity = new ItemEntity((Level)level, (double)pos.m_122239_(), (double)pos.m_122260_(), (double)pos.m_122269_(), itemStack);
            entity.m_19983_(itemStack);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        ISootyChimney sootyChimney;
        Block block;
        boolean isDestroyed = super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        if (isDestroyed && (block = state.m_60734_()) instanceof ISootyChimney && (sootyChimney = (ISootyChimney)block).isDirty()) {
            sootyChimney.makeSootParticles(level, pos);
        }
        return isDestroyed;
    }
}

