/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.delightful.data.gen;

import java.util.Objects;
import java.util.function.Consumer;
import net.brdle.delightful.Util;
import net.brdle.delightful.common.block.DelightfulBlocks;
import net.brdle.delightful.common.block.DelightfulCabinetBlock;
import net.brdle.delightful.common.config.EnabledCondition;
import net.brdle.delightful.common.item.DelightfulItems;
import net.brdle.delightful.common.item.knife.CompatKnifeItem;
import net.brdle.delightful.common.item.knife.DelightfulKnifeItem;
import net.brdle.delightful.common.item.knife.TaggedKnifeItem;
import net.brdle.delightful.common.item.knife.twilightforest.IronwoodKnifeItem;
import net.brdle.delightful.common.item.knife.twilightforest.SteeleafKnifeItem;
import net.brdle.delightful.data.DelightfulItemTags;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.UpgradeRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.NBTIngredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;
import net.onvoid.rottenleather.common.RottenLeatherItems;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.ForgeTags;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.data.builder.CookingPotRecipeBuilder;
import vectorwing.farmersdelight.data.builder.CuttingBoardRecipeBuilder;

public class DelightfulRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public DelightfulRecipeProvider(DataGenerator pGenerator) {
        super(pGenerator);
    }

    protected void m_176531_(@NotNull Consumer<FinishedRecipe> finished) {
        DelightfulBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get).filter(block -> block instanceof DelightfulCabinetBlock).forEach(block -> this.cabinet((DelightfulCabinetBlock)block, finished));
        DelightfulItems.ITEMS.getEntries().stream().map(RegistryObject::get).filter(item -> item instanceof DelightfulKnifeItem).map(item -> (DelightfulKnifeItem)item).filter(k -> !(k instanceof IronwoodKnifeItem) && !(k instanceof SteeleafKnifeItem)).forEach(k -> this.knife((DelightfulKnifeItem)k, finished));
        this.knifeSmeltAndBlast((DelightfulKnifeItem)DelightfulItems.BONE_KNIFE.get(), "bone/knife", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)Items.f_42499_)), finished);
        this.wrap((RecipeBuilder)ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)DelightfulItems.NUT_BUTTER_AND_JELLY_SANDWICH.get())).m_206419_(ForgeTags.BREAD).m_126209_((ItemLike)DelightfulItems.NUT_BUTTER_BOTTLE.get()).m_206419_(DelightfulItemTags.JELLY).m_142284_("has_nut_butter", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)DelightfulItems.NUT_BUTTER_BOTTLE.get()))), "food/nut_butter_and_jelly_sandwich", finished, this.enabled("nut_butter_and_jelly_sandwich"), this.not(this.tagEmpty(DelightfulItemTags.NUTS)));
        this.wrap((RecipeBuilder)ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)DelightfulItems.CHEESEBURGER.get())).m_206419_(ForgeTags.BREAD).m_126209_((ItemLike)ModItems.BEEF_PATTY.get()).m_206419_(DelightfulItemTags.CHEESE_OR_MILK).m_206419_(ForgeTags.SALAD_INGREDIENTS).m_206419_(ForgeTags.CROPS_TOMATO).m_206419_(ForgeTags.CROPS_ONION).m_142284_("has_beef_patty_and_cheese", (CriterionTriggerInstance)this.has(new ItemLike[]{(ItemLike)ModItems.BEEF_PATTY.get(), Items.f_42455_})), "food/cheeseburger", finished, this.enabled("cheeseburger"), this.not(this.itemExists("some_assembly_required", "burger_bun")));
        this.wrap((RecipeBuilder)ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)DelightfulItems.CHEESEBURGER.get())).m_126209_((ItemLike)ModItems.HAMBURGER.get()).m_206419_(DelightfulItemTags.CHEESE_OR_MILK).m_142284_("has_hamburger", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.HAMBURGER.get()))), "food/cheeseburger_from_hamburger", finished, this.enabled("cheeseburger"));
        this.wrap((RecipeBuilder)ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)DelightfulItems.DELUXE_CHEESEBURGER.get())).m_206419_(ForgeTags.BREAD).m_126209_((ItemLike)ModItems.BEEF_PATTY.get()).m_206419_(DelightfulItemTags.CHEESE_OR_MILK).m_126209_((ItemLike)ModItems.BEEF_PATTY.get()).m_206419_(DelightfulItemTags.CHEESE_OR_MILK).m_126209_((ItemLike)ModItems.COOKED_BACON.get()).m_206419_(ForgeTags.SALAD_INGREDIENTS).m_206419_(ForgeTags.CROPS_TOMATO).m_206419_(ForgeTags.CROPS_ONION).m_142284_("has_bacon", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.COOKED_BACON.get()))), "food/deluxe_cheeseburger", finished, this.enabled("deluxe_cheeseburger"), this.not(this.itemExists("some_assembly_required", "burger_bun")));
        this.wrap((RecipeBuilder)ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)DelightfulItems.DELUXE_CHEESEBURGER.get())).m_126209_((ItemLike)DelightfulItems.CHEESEBURGER.get()).m_126209_((ItemLike)ModItems.BEEF_PATTY.get()).m_206419_(DelightfulItemTags.CHEESE_OR_MILK).m_126209_((ItemLike)ModItems.COOKED_BACON.get()).m_142284_("has_cheeseburger", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)DelightfulItems.CHEESEBURGER.get()))), "food/deluxe_cheeseburger_from_cheeseburger", finished, this.enabled("deluxe_cheeseburger"));
        this.wrap((RecipeBuilder)ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)DelightfulItems.MARSHMALLOW_STICK.get()), (int)2).m_206419_(DelightfulItemTags.SUGAR).m_206419_(DelightfulItemTags.WATER).m_206419_(Tags.Items.RODS_WOODEN).m_206419_(Tags.Items.RODS_WOODEN).m_142284_("has_sugar", (CriterionTriggerInstance)DelightfulRecipeProvider.m_206406_(DelightfulItemTags.SUGAR)), "food/marshmallow_stick", finished, this.enabled("marshmallow_stick"));
        this.wrap((RecipeBuilder)ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)DelightfulItems.MARSHMALLOW_STICK.get()), (int)2).m_206419_(DelightfulItemTags.SUGAR).m_126184_((Ingredient)NBTIngredient.of((ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_))).m_206419_(Tags.Items.RODS_WOODEN).m_206419_(Tags.Items.RODS_WOODEN).m_142284_("has_sugar", (CriterionTriggerInstance)DelightfulRecipeProvider.m_206406_(DelightfulItemTags.SUGAR)), "food/marshmallow_stick_from_water_bottle", finished, this.enabled("marshmallow_stick"));
        this.wrap((RecipeBuilder)ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)DelightfulItems.SMORE.get())).m_126209_((ItemLike)ModItems.HONEY_COOKIE.get()).m_126209_((ItemLike)Items.f_42533_).m_206419_(ForgeTags.MILK).m_206419_(DelightfulItemTags.SUGAR).m_126209_((ItemLike)DelightfulItems.COOKED_MARSHMALLOW_STICK.get()).m_126209_((ItemLike)ModItems.HONEY_COOKIE.get()).m_142284_("has_cooked_marshmallow_stick", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)DelightfulItems.COOKED_MARSHMALLOW_STICK.get()))), "food/smore", finished, this.enabled("smore"), this.tagEmpty(DelightfulItemTags.CHOCOLATE));
        this.wrap((RecipeBuilder)ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)DelightfulItems.SMORE.get())).m_126209_((ItemLike)ModItems.HONEY_COOKIE.get()).m_206419_(DelightfulItemTags.CHOCOLATE).m_126209_((ItemLike)DelightfulItems.COOKED_MARSHMALLOW_STICK.get()).m_126209_((ItemLike)ModItems.HONEY_COOKIE.get()).m_142284_("has_cooked_marshmallow_stick", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)DelightfulItems.COOKED_MARSHMALLOW_STICK.get()))), "food/smore_from_chocolate", finished, this.enabled("smore"), this.not(this.tagEmpty(DelightfulItemTags.CHOCOLATE)));
        this.wrap((RecipeBuilder)ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)DelightfulItems.PRICKLY_PEAR_JUICE.get())).m_206419_(DelightfulItemTags.COOKED_PRICKLY_PEAR).m_206419_(DelightfulItemTags.COOKED_PRICKLY_PEAR).m_206419_(DelightfulItemTags.SUGAR).m_206419_(DelightfulItemTags.COOKED_PRICKLY_PEAR).m_206419_(DelightfulItemTags.COOKED_PRICKLY_PEAR).m_126209_((ItemLike)Items.f_42590_).m_142284_("has_cooked_prickly_pear", (CriterionTriggerInstance)DelightfulRecipeProvider.m_206406_(DelightfulItemTags.COOKED_PRICKLY_PEAR)), "food/prickly_pear_juice", finished, this.enabled("prickly_pear_juice"), this.not(this.tagEmpty(DelightfulItemTags.COOKED_PRICKLY_PEAR)));
        this.wrap((RecipeBuilder)ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)DelightfulItems.CRAB_RANGOON.get())).m_126209_((ItemLike)ModItems.WHEAT_DOUGH.get()).m_206419_(DelightfulItemTags.CHEESE_OR_MILK).m_206419_(DelightfulItemTags.COOKED_CRAB).m_142284_("has_cooked_crab", (CriterionTriggerInstance)DelightfulRecipeProvider.m_206406_(DelightfulItemTags.COOKED_CRAB)), "food/crab_rangoon", finished, this.enabled("crab_rangoon"), this.not(this.tagEmpty(DelightfulItemTags.COOKED_CRAB)));
        this.wrap((RecipeBuilder)ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)DelightfulItems.CHUNKWICH.get())).m_206419_(ForgeTags.BREAD).m_126209_((ItemLike)RottenLeatherItems.SWEETENED_CHUNK.get()).m_142284_("has_sweetened_chunk", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)RottenLeatherItems.SWEETENED_CHUNK.get()))), "food/chunkwich", finished, this.enabled("chunkwich"), this.itemExists("rottenleather", "sweetened_chunk"), this.not(this.itemExists("some_assembly_required", "burger_bun")));
        this.wrap((RecipeBuilder)SimpleCookingRecipeBuilder.m_176784_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DelightfulItems.MARSHMALLOW_STICK.get()}), (ItemLike)((ItemLike)DelightfulItems.COOKED_MARSHMALLOW_STICK.get()), (float)0.5f, (int)600).m_142284_("has_marshmallow_stick", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)DelightfulItems.MARSHMALLOW_STICK.get()))), "food/cooked_marshmallow_stick", finished, this.enabled("cooked_marshmallow_stick"));
        this.wrap((RecipeBuilder)ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)DelightfulItems.HONEY_GLAZED_WALNUT.get()), (int)3).m_206419_(DelightfulItemTags.NUTS_WALNUT).m_206419_(DelightfulItemTags.NUTS_WALNUT).m_206419_(DelightfulItemTags.NUTS_WALNUT).m_126209_((ItemLike)Items.f_42787_).m_142284_("has_walnut", (CriterionTriggerInstance)DelightfulRecipeProvider.m_206406_(DelightfulItemTags.NUTS_WALNUT)), "food/honey_glazed_walnut", finished, this.enabled("honey_glazed_walnut"), this.not(this.tagEmpty(DelightfulItemTags.NUTS_WALNUT)));
        this.wrap((RecipeBuilder)SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_204132_(DelightfulItemTags.TEA_LEAVES_GREEN), (ItemLike)((ItemLike)DelightfulItems.MATCHA.get()), (float)0.1f, (int)200).m_142284_("has_green_tea_leaf", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)DelightfulItems.GREEN_TEA_LEAF.get()))), "smelting/green_tea_leaf", finished, this.enabled("matcha"));
        this.wrap((RecipeBuilder)SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_204132_(DelightfulItemTags.TEA_LEAVES_GREEN), (ItemLike)((ItemLike)DelightfulItems.MATCHA.get()), (float)0.1f, (int)100).m_142284_("has_green_tea_leaf", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)DelightfulItems.GREEN_TEA_LEAF.get()))), "blasting/green_tea_leaf", finished, this.enabled("matcha"));
        this.wrap((RecipeBuilder)ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)DelightfulItems.MATCHA_LATTE.get()), (int)1).m_126209_((ItemLike)Items.f_42590_).m_206419_(ForgeTags.MILK).m_126209_((ItemLike)Items.f_42787_).m_126209_((ItemLike)DelightfulItems.MATCHA.get()).m_142284_("has_matcha", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)DelightfulItems.MATCHA.get()))), "food/matcha_latte", finished, this.enabled("matcha_latte"));
        this.wrap((RecipeBuilder)ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)DelightfulItems.BERRY_MATCHA_LATTE.get()), (int)1).m_126209_((ItemLike)Items.f_42590_).m_206419_(DelightfulItemTags.FRUITS_BERRIES).m_206419_(ForgeTags.MILK).m_126209_((ItemLike)Items.f_42787_).m_126209_((ItemLike)DelightfulItems.MATCHA.get()).m_142284_("has_matcha_latte", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)DelightfulItems.MATCHA_LATTE.get()))), "food/berry_matcha_latte", finished, this.enabled("berry_matcha_latte"));
        this.wrap((RecipeBuilder)ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)DelightfulItems.ROCK_CANDY.get()), (int)1).m_206419_(DelightfulItemTags.GEMS_ROSE_QUARTZ).m_206419_(DelightfulItemTags.GEMS_ROSE_QUARTZ).m_206419_(DelightfulItemTags.SUGAR).m_206419_(Tags.Items.RODS_WOODEN).m_142284_("has_rose_quartz", (CriterionTriggerInstance)DelightfulRecipeProvider.m_206406_(DelightfulItemTags.GEMS_ROSE_QUARTZ)), "food/rock_candy", finished, this.enabled("rock_candy"), this.not(this.tagEmpty(DelightfulItemTags.GEMS_ROSE_QUARTZ)));
        this.wrap((RecipeBuilder)SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DelightfulItems.CACTUS_FLESH.get()}), (ItemLike)((ItemLike)DelightfulItems.CACTUS_STEAK.get()), (float)0.1f, (int)200).m_142284_("has_cactus_flesh", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)DelightfulItems.CACTUS_FLESH.get()))), "smelting/cactus_flesh", finished, this.enabled("cactus_steak"));
        this.wrap((RecipeBuilder)ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)DelightfulItems.FIELD_SALAD.get()), (int)1).m_126209_((ItemLike)Items.f_42399_).m_206419_(ForgeTags.SALAD_INGREDIENTS).m_206419_(ForgeTags.SALAD_INGREDIENTS).m_126209_((ItemLike)DelightfulItems.CACTUS_STEAK.get()).m_126209_((ItemLike)Items.f_42619_).m_206419_(DelightfulItemTags.FRUITS_SALMONBERRIES).m_142284_("has_cactus_steak", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)DelightfulItems.CACTUS_STEAK.get()))), "food/field_salad", finished, this.enabled("field_salad"));
        this.wrap((RecipeBuilder)ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)DelightfulItems.SALMONBERRY_SACK.get()), (int)1).m_206419_(DelightfulItemTags.FRUITS_SALMONBERRIES).m_206419_(DelightfulItemTags.FRUITS_SALMONBERRIES).m_206419_(DelightfulItemTags.FRUITS_SALMONBERRIES).m_206419_(DelightfulItemTags.FRUITS_SALMONBERRIES).m_206419_(DelightfulItemTags.FRUITS_SALMONBERRIES).m_206419_(DelightfulItemTags.FRUITS_SALMONBERRIES).m_206419_(DelightfulItemTags.FRUITS_SALMONBERRIES).m_206419_(DelightfulItemTags.FRUITS_SALMONBERRIES).m_206419_(DelightfulItemTags.FRUITS_SALMONBERRIES).m_142284_("has_salmonberries", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)DelightfulItems.SALMONBERRIES.get()))), "storage/salmonberry_sack", finished, this.enabled("salmonberry_sack"));
        this.wrap((RecipeBuilder)ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)DelightfulItems.SALMONBERRIES.get()), (int)9).m_126209_((ItemLike)DelightfulItems.SALMONBERRY_SACK.get()).m_142284_("has_salmonberry_sack", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)DelightfulItems.SALMONBERRY_SACK.get()))), "storage/unpack_salmonberry_sack", finished, this.enabled("salmonberry_sack"));
        this.wrap((RecipeBuilder)ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)DelightfulItems.SALMONBERRY_PIPS.get())).m_126209_((ItemLike)DelightfulItems.SALMONBERRIES.get()).m_142284_("has_salmonberries", (CriterionTriggerInstance)DelightfulRecipeProvider.m_206406_(DelightfulItemTags.FRUITS_SALMONBERRIES)), "salmonberry_pips", finished, this.enabled("salmonberry_pips"));
        this.wrap((RecipeBuilder)ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)DelightfulItems.ACORN_SACK.get()), (int)1).m_206419_(DelightfulItemTags.NUTS_ACORN).m_206419_(DelightfulItemTags.NUTS_ACORN).m_206419_(DelightfulItemTags.NUTS_ACORN).m_206419_(DelightfulItemTags.NUTS_ACORN).m_206419_(DelightfulItemTags.NUTS_ACORN).m_206419_(DelightfulItemTags.NUTS_ACORN).m_206419_(DelightfulItemTags.NUTS_ACORN).m_206419_(DelightfulItemTags.NUTS_ACORN).m_206419_(DelightfulItemTags.NUTS_ACORN).m_142284_("has_acorn", (CriterionTriggerInstance)DelightfulRecipeProvider.m_206406_(DelightfulItemTags.NUTS_ACORN)), "storage/acorn_sack", finished, this.enabled("acorn_sack"));
        this.wrap((RecipeBuilder)ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)DelightfulItems.ACORN.get()), (int)9).m_126209_((ItemLike)DelightfulItems.ACORN_SACK.get()).m_142284_("has_acorn_sack", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)DelightfulItems.ACORN_SACK.get()))), "storage/unpack_acorn_sack", finished, this.enabled("acorn_sack"));
        this.wrap((RecipeBuilder)SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DelightfulItems.VENISON_CHOPS.get()}), (ItemLike)((ItemLike)DelightfulItems.COOKED_VENISON_CHOPS.get()), (float)0.35f, (int)200).m_142284_("has_venison_chops", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)DelightfulItems.VENISON_CHOPS.get()))), "cooking/venison_chops", finished, this.enabled("cooked_venison_chops"));
        this.wrap((RecipeBuilder)SimpleCookingRecipeBuilder.m_176796_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DelightfulItems.VENISON_CHOPS.get()}), (ItemLike)((ItemLike)DelightfulItems.COOKED_VENISON_CHOPS.get()), (float)0.35f, (int)100).m_142284_("has_venison_chops", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)DelightfulItems.VENISON_CHOPS.get()))), "cooking/venison_chops_from_smoking", finished, this.enabled("cooked_venison_chops"));
        this.wrap((RecipeBuilder)SimpleCookingRecipeBuilder.m_176784_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DelightfulItems.VENISON_CHOPS.get()}), (ItemLike)((ItemLike)DelightfulItems.COOKED_VENISON_CHOPS.get()), (float)0.35f, (int)600).m_142284_("has_venison_chops", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)DelightfulItems.VENISON_CHOPS.get()))), "cooking/venison_chops_from_campfire_cooking", finished, this.enabled("cooked_venison_chops"));
        this.wrap((RecipeBuilder)SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DelightfulItems.RAW_GOAT.get()}), (ItemLike)((ItemLike)DelightfulItems.COOKED_GOAT.get()), (float)0.35f, (int)200).m_142284_("has_raw_goat", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)DelightfulItems.RAW_GOAT.get()))), "cooking/raw_goat", finished, this.enabled("cooked_goat"));
        this.wrap((RecipeBuilder)SimpleCookingRecipeBuilder.m_176796_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DelightfulItems.RAW_GOAT.get()}), (ItemLike)((ItemLike)DelightfulItems.COOKED_GOAT.get()), (float)0.35f, (int)100).m_142284_("has_raw_goat", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)DelightfulItems.RAW_GOAT.get()))), "cooking/raw_goat_from_smoking", finished, this.enabled("cooked_goat"));
        this.wrap((RecipeBuilder)SimpleCookingRecipeBuilder.m_176784_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DelightfulItems.RAW_GOAT.get()}), (ItemLike)((ItemLike)DelightfulItems.COOKED_GOAT.get()), (float)0.35f, (int)600).m_142284_("has_raw_goat", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)DelightfulItems.RAW_GOAT.get()))), "cooking/raw_goat_from_campfire_cooking", finished, this.enabled("cooked_goat"));
        ConditionalRecipe.builder().addCondition((ICondition)this.enabled("ender_nectar")).addRecipe(f -> CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)DelightfulItems.ENDER_NECTAR.get()), (int)1, (int)200, (float)0.35f).addIngredient((ItemLike)Items.f_42545_).addIngredient(ForgeTags.MILK).addIngredient(DelightfulItemTags.SUGAR).build(f)).generateAdvancement().build(finished, "delightful", "food/cooking/ender_nectar");
        ConditionalRecipe.builder().addCondition((ICondition)this.enabled("animal_oil_bottle")).addRecipe(f -> CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)DelightfulItems.ANIMAL_OIL_BOTTLE.get()), (int)1, (int)200, (float)0.35f).addIngredient((ItemLike)DelightfulItems.ANIMAL_FAT.get()).addIngredient((ItemLike)DelightfulItems.ANIMAL_FAT.get()).build(f)).generateAdvancement().build(finished, "delightful", "cooking/animal_oil_bottle");
        ConditionalRecipe.builder().addCondition((ICondition)this.enabled("jelly_bottle")).addRecipe(f -> CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)DelightfulItems.JELLY_BOTTLE.get()), (int)1, (int)200, (float)0.35f).addIngredient(DelightfulItemTags.FRUITS_SWEET).addIngredient(DelightfulItemTags.FRUITS_SWEET).addIngredient(DelightfulItemTags.SUGAR).addIngredient(DelightfulItemTags.SUGAR).build(f)).generateAdvancement().build(finished, "delightful", "food/cooking/jelly_bottle");
        ConditionalRecipe.builder().addCondition((ICondition)this.enabled("glow_jelly_bottle")).addRecipe(f -> CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)DelightfulItems.GLOW_JELLY_BOTTLE.get()), (int)1, (int)200, (float)0.35f).addIngredient(DelightfulItemTags.FRUITS_GLOW_BERRIES).addIngredient(Tags.Items.DUSTS_GLOWSTONE).addIngredient(DelightfulItemTags.SUGAR).addIngredient(DelightfulItemTags.SUGAR).build(f)).generateAdvancement().build(finished, "delightful", "food/cooking/glow_jelly_bottle");
        ConditionalRecipe.builder().addCondition(this.and(new ICondition[]{this.enabled("nut_butter_bottle"), this.not(this.tagEmpty(DelightfulItemTags.NUTS))})).addRecipe(f -> CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)DelightfulItems.NUT_BUTTER_BOTTLE.get()), (int)1, (int)200, (float)0.35f).addIngredient(DelightfulItemTags.NUTS).addIngredient(DelightfulItemTags.SUGAR).build(f)).generateAdvancement().build(finished, "delightful", "food/cooking/nut_butter_bottle");
        ConditionalRecipe.builder().addCondition(this.and(new ICondition[]{this.enabled("chunk_nugget"), this.itemExists("rottenleather", "sweetened_chunk")})).addRecipe(f -> CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)DelightfulItems.CHUNK_NUGGET.get()), (int)6, (int)100, (float)0.25f).addIngredient(ForgeTags.BREAD).addIngredient((ItemLike)RottenLeatherItems.SWEETENED_CHUNK.get()).addIngredient((ItemLike)RottenLeatherItems.SWEETENED_CHUNK.get()).build(f)).generateAdvancement().build(finished, "delightful", "food/chunk_nugget");
        ConditionalRecipe.builder().addCondition(this.and(new ICondition[]{this.enabled("azalea_tea"), this.itemExists("ecologics", "azalea_flower")})).addRecipe(f -> CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)DelightfulItems.AZALEA_TEA.get()), (int)1, (int)200, (float)0.35f).addIngredient((Ingredient)NBTIngredient.of((ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_))).addIngredient(DelightfulItemTags.TEA_LEAVES_GREEN).addIngredient((ItemLike)this.modItem("ecologics", "azalea_flower")).build(f)).generateAdvancement().build(finished, "delightful", "food/azalea_tea");
        ConditionalRecipe.builder().addCondition(this.and(new ICondition[]{this.enabled("lavender_tea"), this.itemExists("biomesoplenty", "lavender")})).addRecipe(f -> CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)DelightfulItems.LAVENDER_TEA.get()), (int)1, (int)200, (float)0.35f).addIngredient((Ingredient)NBTIngredient.of((ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_))).addIngredient(DelightfulItemTags.TEA_LEAVES_GREEN).addIngredient((ItemLike)this.modItem("biomesoplenty", "lavender")).build(f)).generateAdvancement().build(finished, "delightful", "food/lavender_tea");
        ConditionalRecipe.builder().addCondition((ICondition)this.enabled("nut_milk")).addRecipe(f -> CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)Items.f_42455_, (int)1, (int)200, (float)0.35f, (ItemLike)Items.f_42446_).addIngredient(DelightfulItemTags.WATER).addIngredient(DelightfulItemTags.NUTS).addIngredient(DelightfulItemTags.NUTS).addIngredient(DelightfulItemTags.SUGAR).build(f)).build(finished, "delightful", "nut_milk");
        ShapedRecipeBuilder.m_126118_((ItemLike)Items.f_42000_, (int)8).m_126127_(Character.valueOf('o'), (ItemLike)DelightfulItems.ANIMAL_OIL_BOTTLE.get()).m_206416_(Character.valueOf('s'), Tags.Items.RODS_WOODEN).m_126130_("o").m_126130_("s").m_142284_("has_oil_bottle", (CriterionTriggerInstance)DelightfulRecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)DelightfulItems.ANIMAL_OIL_BOTTLE.get()}).m_45077_()})).m_176500_(finished, "torch_from_animal_oil_bottle");
        ShapedRecipeBuilder.m_126118_((ItemLike)Items.f_151065_, (int)1).m_126127_(Character.valueOf('f'), (ItemLike)DelightfulItems.ANIMAL_FAT.get()).m_206416_(Character.valueOf('s'), Tags.Items.STRING).m_126130_("s").m_126130_("f").m_126130_("f").m_142284_("has_fat", (CriterionTriggerInstance)DelightfulRecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)DelightfulItems.ANIMAL_FAT.get()}).m_45077_()})).m_176500_(finished, "candle_from_animal_fat");
        ConditionalRecipe.builder().addCondition(this.itemExists("ecologics", "tropical_stew")).addRecipe(f -> CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)this.modItem("ecologics", "tropical_stew"), (int)1, (int)200, (float)0.35f, (ItemLike)this.modItem("ecologics", "coconut_slice")).addIngredient(DelightfulItemTags.COOKED_CRAB).addIngredient(ForgeTags.CROPS_RICE).addIngredient(ForgeTags.CROPS_ONION).build(f)).generateAdvancement().build(finished, "ecologics", "tropical_stew");
        ConditionalRecipe.builder().addCondition(this.and(new ICondition[]{this.enabled("chopped_clover"), this.itemExists("biomesoplenty", "clover")})).addRecipe(f -> CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.modItem("biomesoplenty", "clover")}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)DelightfulItems.CHOPPED_CLOVER.get()), (int)2).build(f)).build(finished, "delightful", "chopped_clover");
        ConditionalRecipe.builder().addCondition(this.and(new ICondition[]{this.enabled("chopped_clover"), this.itemExists("biomesoplenty", "huge_clover_petal")})).addRecipe(f -> CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.modItem("biomesoplenty", "huge_clover_petal")}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)DelightfulItems.CHOPPED_CLOVER.get()), (int)4).build(f)).build(finished, "delightful", "chopped_clover_from_huge_clover_petal");
        ConditionalRecipe.builder().addCondition(this.and(new ICondition[]{this.enabled("clover_honey"), this.modLoaded("biomesoplenty")})).addRecipe(f -> CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)Items.f_42787_, (int)3, (int)200, (float)0.35f).addIngredient((ItemLike)Items.f_42787_, 2).addIngredient((ItemLike)DelightfulItems.CHOPPED_CLOVER.get(), 4).build(f)).build(finished, "delightful", "clover_honey");
        ConditionalRecipe.builder().addCondition(this.and(new ICondition[]{this.enabled("venison_chops"), this.not(this.tagEmpty(DelightfulItemTags.RAW_VENISON))})).addRecipe(f -> CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_204132_(DelightfulItemTags.RAW_VENISON), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)DelightfulItems.VENISON_CHOPS.get()), (int)2).build(f)).build(finished, "delightful", "venison");
        ConditionalRecipe.builder().addCondition(this.and(new ICondition[]{this.enabled("cooked_venison_chops"), this.not(this.tagEmpty(DelightfulItemTags.COOKED_VENISON))})).addRecipe(f -> CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_204132_(DelightfulItemTags.COOKED_VENISON), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)DelightfulItems.COOKED_VENISON_CHOPS.get()), (int)2).build(f)).build(finished, "delightful", "cooked_venison");
        ConditionalRecipe.builder().addCondition((ICondition)this.enabled("cactus_flesh")).addRecipe(f -> CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41982_}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)DelightfulItems.CACTUS_FLESH.get()), (int)2).build(f)).build(finished, "delightful", "cactus_flesh");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DelightfulItems.MINI_MELON.get()}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)Items.f_42575_, (int)6).build(finished);
        ShapelessRecipeBuilder.m_126191_((ItemLike)Items.f_42575_, (int)3).m_126209_((ItemLike)DelightfulItems.MINI_MELON.get()).m_142284_("has_mini_melon", (CriterionTriggerInstance)DelightfulRecipeProvider.m_125977_((ItemLike)((ItemLike)DelightfulItems.MINI_MELON.get()))).m_176498_(finished);
        ConditionalRecipe.builder().addCondition(this.not(this.tagEmpty(DelightfulItemTags.CHOCOLATE))).addRecipe(f -> ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ModItems.CHOCOLATE_PIE.get()), (int)1).m_126130_("ccc").m_126130_("mmm").m_126130_("xOx").m_206416_(Character.valueOf('c'), DelightfulItemTags.CHOCOLATE).m_206416_(Character.valueOf('m'), ForgeTags.MILK).m_126127_(Character.valueOf('x'), (ItemLike)Items.f_42501_).m_126127_(Character.valueOf('O'), (ItemLike)ModItems.PIE_CRUST.get()).m_142284_("has_pie_crust", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PIE_CRUST.get()})).m_176498_(f)).addCondition(this.tagEmpty(DelightfulItemTags.CHOCOLATE)).addRecipe(f -> ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ModItems.CHOCOLATE_PIE.get()), (int)1).m_126130_("ccc").m_126130_("mmm").m_126130_("xOx").m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42533_).m_206416_(Character.valueOf('m'), ForgeTags.MILK).m_126127_(Character.valueOf('x'), (ItemLike)Items.f_42501_).m_126127_(Character.valueOf('O'), (ItemLike)ModItems.PIE_CRUST.get()).m_142284_("has_pie_crust", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PIE_CRUST.get()})).m_176498_(f)).generateAdvancement().build(finished, "farmersdelight", "chocolate_pie");
    }

    private InventoryChangeTrigger.TriggerInstance has(ItemLike ... items) {
        return InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])items);
    }

    private void wrap(RecipeBuilder builder, String name, Consumer<FinishedRecipe> consumer, ICondition ... conds) {
        ResourceLocation loc = new ResourceLocation("delightful", name);
        ConditionalRecipe.Builder cond = conds.length > 1 ? ConditionalRecipe.builder().addCondition(this.and(conds)) : (conds.length == 1 ? ConditionalRecipe.builder().addCondition(conds[0]) : ConditionalRecipe.builder());
        FinishedRecipe[] recipe = new FinishedRecipe[1];
        builder.m_142700_(f -> {
            recipe[0] = f;
        }, loc);
        cond.addRecipe(recipe[0]).generateAdvancement().build(consumer, loc);
    }

    private Item modItem(String modid, String path) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(modid, path));
    }

    private void cabinet(DelightfulCabinetBlock block, Consumer<FinishedRecipe> finished) {
        String path = Util.name((Block)block);
        ConditionalRecipe.builder().addCondition((ICondition)this.enabled(path)).addRecipe(f -> ShapedRecipeBuilder.m_126116_((ItemLike)block).m_126124_(Character.valueOf('b'), block.getIngredient().get()).m_206416_(Character.valueOf('c'), ModTags.WOODEN_CABINETS).m_126130_("bbb").m_126130_("bcb").m_126130_("bbb").m_142284_("has_cabinet", (CriterionTriggerInstance)DelightfulRecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(ModTags.CABINETS).m_45077_()})).m_176498_(f)).generateAdvancement().build(finished, "delightful", "cabinets/" + path);
    }

    private void knife(DelightfulKnifeItem knife, Consumer<FinishedRecipe> finished) {
        if (knife instanceof TaggedKnifeItem) {
            TaggedKnifeItem tki = (TaggedKnifeItem)knife;
            this.taggedKnife(tki, finished);
            return;
        }
        String path = Util.name((Item)knife);
        ConditionalRecipe.builder().addCondition(this.and(new ICondition[]{this.enabled(path)})).addRecipe(f -> ShapedRecipeBuilder.m_126116_((ItemLike)knife).m_126124_(Character.valueOf('m'), knife.getIngredient().get()).m_126124_(Character.valueOf('s'), knife.getRod().get()).m_126130_("m").m_126130_("s").m_142284_("has_" + path.replace("_knife", ""), (CriterionTriggerInstance)DelightfulRecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{knife.getIngredient().get().m_43908_()[0].m_41720_()}).m_45077_()})).m_176498_(f)).generateAdvancement().build(finished, "delightful", "knives/" + path);
    }

    private void taggedKnife(TaggedKnifeItem knife, Consumer<FinishedRecipe> finished) {
        ICondition iCondition;
        if (knife.isSmithing()) {
            this.knifeSmith(knife, finished);
            return;
        }
        if (knife.getTag() == null) {
            return;
        }
        String path = Util.name((Item)knife);
        TagKey add = ItemTags.create((ResourceLocation)knife.getTag());
        if (knife instanceof CompatKnifeItem) {
            CompatKnifeItem cki = (CompatKnifeItem)knife;
            iCondition = this.and(new ICondition[]{this.enabled(path), this.modLoaded(cki.getModid()), this.not(this.tagEmpty(add))});
        } else {
            iCondition = this.and(new ICondition[]{this.enabled(path), this.not(this.tagEmpty(add))});
        }
        ICondition cond = iCondition;
        ConditionalRecipe.builder().addCondition(cond).addRecipe(f -> ShapedRecipeBuilder.m_126116_((ItemLike)knife).m_126124_(Character.valueOf('m'), knife.getIngredient().get()).m_126124_(Character.valueOf('s'), knife.getRod().get()).m_126130_("m").m_126130_("s").m_142284_("has_" + path.replace("_knife", ""), (CriterionTriggerInstance)DelightfulRecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(ItemTags.create((ResourceLocation)knife.getTag())).m_45077_()})).m_176498_(f)).generateAdvancement().build(finished, "delightful", "knives/" + path);
    }

    private void knifeSmeltAndBlast(DelightfulKnifeItem knife, String metal, ResourceLocation nugget, Consumer<FinishedRecipe> finished) {
        ConditionalRecipe.builder().addCondition(this.and(new ICondition[]{this.enabled(Util.name((Item)knife)), this.itemExists(nugget.m_135827_(), nugget.m_135815_())})).addRecipe(f -> SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{knife}), (ItemLike)((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(nugget))), (float)0.1f, (int)200).m_142284_("has_" + metal + "_knife", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{knife})).m_142700_(f, new ResourceLocation("delightful", "knives/smelting/" + metal + "_" + nugget.m_135827_()))).generateAdvancement().build(finished, "delightful", "knives/smelting/" + metal + "_" + nugget.m_135827_());
        ConditionalRecipe.builder().addCondition(this.and(new ICondition[]{this.enabled(Util.name((Item)knife)), this.itemExists(nugget.m_135827_(), nugget.m_135815_())})).addRecipe(f -> SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{knife}), (ItemLike)((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(nugget))), (float)0.1f, (int)100).m_142284_("has_" + metal + "_knife", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{knife})).m_142700_(f, new ResourceLocation("delightful", "knives/blasting/" + metal + "_" + nugget.m_135827_()))).generateAdvancement().build(finished, "delightful", "knives/blasting/" + metal + "_" + nugget.m_135827_());
    }

    private void knifeSmith(TaggedKnifeItem knife, Consumer<FinishedRecipe> finished) {
        String path = Util.name((Item)knife);
        TagKey add = ItemTags.create((ResourceLocation)knife.getTag());
        ConditionalRecipe.builder().addCondition(this.and(new ICondition[]{this.enabled(path), this.not(this.tagEmpty(add))})).addRecipe(f -> UpgradeRecipeBuilder.m_126385_((Ingredient)knife.getIngredient().get(), (Ingredient)Ingredient.m_204132_((TagKey)add), (Item)knife).m_126389_("has_metal", (CriterionTriggerInstance)DelightfulRecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(add).m_45077_()})).m_126395_(f, new ResourceLocation("delightful", path + "_smithing"))).generateAdvancement().build(finished, "delightful", "knives/" + path + "_smithing");
    }

    private EnabledCondition enabled(String name) {
        return new EnabledCondition(name);
    }
}

