/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.delightful.data.gen;

import net.brdle.delightful.Util;
import net.brdle.delightful.common.block.DelightfulBlocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import vectorwing.farmersdelight.common.block.CabinetBlock;

public class DelightfulBlockStateProvider
extends BlockStateProvider {
    public DelightfulBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "delightful", exFileHelper);
    }

    protected void registerStatesAndModels() {
        DelightfulBlocks.BLOCKS.getEntries().stream().filter(entry -> entry.get() instanceof CabinetBlock).forEach(cab -> this.cabinet((Block)cab.get()));
        this.wildCropBlock((Block)DelightfulBlocks.WILD_SALMONBERRIES.get());
        this.simpleBlock((Block)DelightfulBlocks.SALMONBERRY_SACK.get(), (ModelFile)this.models().cubeBottomTop("salmonberry_sack", new ResourceLocation("delightful", "block/salmonberry_sack"), new ResourceLocation("delightful", "block/salmonberry_sack_bottom"), new ResourceLocation("delightful", "block/salmonberry_sack_top")));
        this.simpleBlock((Block)DelightfulBlocks.ACORN_SACK.get(), (ModelFile)this.models().cubeBottomTop("acorn_sack", new ResourceLocation("delightful", "block/acorn_sack"), new ResourceLocation("delightful", "block/acorn_sack_bottom"), new ResourceLocation("delightful", "block/acorn_sack_top")));
    }

    public void wildCropBlock(Block block) {
        this.simpleBlock(block, (ModelFile)this.models().singleTexture(Util.name(block), new ResourceLocation("farmersdelight", "bush_crop"), "crop", this.resourceBlock(Util.name(block))));
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("delightful", "block/" + path);
    }

    public void cabinet(Block block) {
        String path = Util.name(block);
        String type = path.replace("_cabinet", "").trim();
        this.horizontalBlock(block, state -> {
            String suffix = (Boolean)state.m_61143_((Property)CabinetBlock.OPEN) != false ? "_open" : "";
            return this.models().orientable(path + suffix, this.resourceBlock(type + "_cabinet_side"), this.resourceBlock(type + "_cabinet_front" + suffix), this.resourceBlock(type + "_cabinet_top"));
        });
    }
}

