/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.delightful.common.tile;

import net.brdle.delightful.common.tile.DelightfulTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;

public class PizzaStoneBlockEntity
extends SyncedBlockEntity
implements HeatableBlockEntity {
    private final ItemStackHandler inventory = this.createHandler();
    private int cookingTime;
    private int cookingTimeTotal;
    private ItemStack stack = ItemStack.f_41583_;

    public PizzaStoneBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DelightfulTiles.PIZZA_STONE.get(), pos, state);
    }

    public static void cookingTick(Level level, BlockPos pos, BlockState state, PizzaStoneBlockEntity stone) {
        boolean isHeated = stone.isHeated(level, pos);
        if (isHeated) {
            ItemStack cookingStack = stone.getStoredStack();
            if (cookingStack.m_41619_()) {
                stone.cookingTime = 0;
            } else {
                stone.cookAndOutputItems(cookingStack);
            }
        } else if (stone.cookingTime > 0) {
            stone.cookingTime = Mth.m_14045_((int)(stone.cookingTime - 2), (int)0, (int)stone.cookingTimeTotal);
        }
    }

    private void cookAndOutputItems(ItemStack cookingStack) {
        if (this.f_58857_ == null) {
            return;
        }
        ++this.cookingTime;
        if (this.cookingTime >= this.cookingTimeTotal) {
            SimpleContainer simpleContainer = new SimpleContainer(new ItemStack[]{cookingStack});
        }
    }

    public boolean isCooking() {
        return this.isHeated() && this.hasStoredStack();
    }

    public boolean isHeated() {
        return this.f_58857_ != null && this.isHeated(this.f_58857_, this.f_58858_);
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.cookingTime = compound.m_128451_("CookTime");
        this.cookingTimeTotal = compound.m_128451_("CookTimeTotal");
        this.stack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Skillet"));
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128405_("CookTime", this.cookingTime);
        compound.m_128405_("CookTimeTotal", this.cookingTimeTotal);
        compound.m_128365_("Skillet", (Tag)this.stack.m_41739_(new CompoundTag()));
    }

    public CompoundTag writePizzaStoneItem(CompoundTag compound) {
        compound.m_128365_("Stone", (Tag)this.stack.m_41739_(new CompoundTag()));
        return compound;
    }

    public void setPizzaStoneItem(ItemStack cop) {
        this.stack = cop.m_41777_();
        this.inventoryChanged();
    }

    public ItemStack removeItem() {
        return this.inventory.extractItem(0, this.getStoredStack().m_41741_(), false);
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getStoredStack() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean hasStoredStack() {
        return !this.getStoredStack().m_41619_();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(){

            protected void onContentsChanged(int slot) {
                PizzaStoneBlockEntity.this.inventoryChanged();
            }
        };
    }

    public void m_7651_() {
        super.m_7651_();
    }
}

