/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.delightful.common.loot;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AddItemLootModifier
extends LootModifier {
    private final Item item;
    private final int minAmount;
    private final int maxAmount;
    private final boolean unique;

    public AddItemLootModifier(LootItemCondition[] conditions, Item item, int minAmount, int maxAmount, boolean unique) {
        super(conditions);
        this.item = item;
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
        this.unique = unique;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (this.unique && generatedLoot.stream().anyMatch(stack -> stack.m_41720_().equals(this.item)) || this.maxAmount < 1) {
            return generatedLoot;
        }
        int amount = new Random().nextInt(this.maxAmount + 1 - this.minAmount) + this.minAmount;
        if (amount >= 1) {
            generatedLoot.add(new ItemStack((ItemLike)this.item, amount));
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddItemLootModifier> {
        public AddItemLootModifier read(ResourceLocation name, JsonObject object, LootItemCondition[] conditions) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"item")));
            int minAmount = GsonHelper.m_13927_((JsonObject)object, (String)"minAmount");
            int maxAmount = GsonHelper.m_13927_((JsonObject)object, (String)"maxAmount");
            boolean unique = GsonHelper.m_13912_((JsonObject)object, (String)"unique");
            return new AddItemLootModifier(conditions, item, minAmount, maxAmount, unique);
        }

        public JsonObject write(AddItemLootModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.item).toString());
            json.addProperty("minAmount", (Number)instance.minAmount);
            json.addProperty("maxAmount", (Number)instance.maxAmount);
            json.addProperty("unique", Boolean.valueOf(instance.unique));
            return json;
        }
    }
}

