/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.delightful.common.item.knife;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.brdle.delightful.common.item.knife.DelightfulKnifeItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class TaggedKnifeItem
extends DelightfulKnifeItem {
    private final ResourceLocation tag;
    private final boolean smith;

    public TaggedKnifeItem(ResourceLocation tag, Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties properties) {
        super(() -> Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)tag)), tier, attackDamageIn, attackSpeedIn, properties);
        this.tag = tag;
        this.smith = false;
    }

    public TaggedKnifeItem(Supplier<Ingredient> base, ResourceLocation tag, Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties properties) {
        super(base, tier, attackDamageIn, attackSpeedIn, properties);
        this.tag = tag;
        this.smith = true;
    }

    @Nullable
    public ResourceLocation getTag() {
        return this.tag;
    }

    public boolean isTag() {
        return !Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).getTag(ItemTags.create((ResourceLocation)this.tag)).isEmpty();
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.isTag();
    }

    public boolean isSmithing() {
        return this.smith;
    }

    @Override
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> tool, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, tool, pIsAdvanced);
        if (!this.isTag() && this.config()) {
            tool.add((Component)new TextComponent("Requires non-empty tag:"));
            tool.add((Component)new TextComponent(this.tag.m_135827_() + ":" + this.tag.m_135815_()).m_130940_(ChatFormatting.UNDERLINE));
        }
    }
}

