/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.delightful.common.item.knife;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.brdle.delightful.common.item.knife.TaggedKnifeItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;

public class CompatKnifeItem
extends TaggedKnifeItem {
    private final String modid;
    private final Component tool;

    public CompatKnifeItem(String modid, ResourceLocation tag, Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties properties) {
        super(tag, tier, attackDamageIn, attackSpeedIn, properties);
        this.modid = modid;
        this.tool = new TextComponent("");
    }

    public CompatKnifeItem(String modid, ResourceLocation tag, Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties properties, Component tool) {
        super(tag, tier, attackDamageIn, attackSpeedIn, properties);
        this.modid = modid;
        this.tool = tool;
    }

    public CompatKnifeItem(String modid, Supplier<Ingredient> base, ResourceLocation tag, Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties properties) {
        super(base, tag, tier, attackDamageIn, attackSpeedIn, properties);
        this.modid = modid;
        this.tool = new TextComponent("");
    }

    public String getModid() {
        return this.modid;
    }

    public boolean isLoaded() {
        return ModList.get().isLoaded(this.modid);
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.isLoaded();
    }

    @Override
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> tool, TooltipFlag pIsAdvanced) {
        if (!this.config()) {
            tool.add((Component)new TextComponent("Disabled.").m_130940_(ChatFormatting.UNDERLINE));
        } else if (!this.isLoaded()) {
            tool.add((Component)new TextComponent("Requires modid:"));
            tool.add((Component)new TextComponent(this.modid).m_130940_(ChatFormatting.UNDERLINE));
        } else if (!this.tool.getString().equals(new TextComponent("").getString())) {
            tool.add(this.tool);
        }
    }

    @Override
    protected boolean m_41389_(CreativeModeTab pCategory) {
        return super.m_41389_(pCategory) && this.isEnabled();
    }
}

