/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.delightful.common.item.food;

import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import vectorwing.farmersdelight.common.item.MelonJuiceItem;

public class DrinkItem
extends MelonJuiceItem {
    private final Supplier<MobEffect> effect;
    private final int duration;
    private final int amplifier;
    private final float heal;
    private final int feed;

    public DrinkItem(Item.Properties properties, Supplier<MobEffect> effect, int duration, int amplifier) {
        super(properties);
        this.effect = effect;
        this.duration = duration;
        this.amplifier = amplifier;
        this.heal = 0.0f;
        this.feed = 0;
    }

    public DrinkItem(Item.Properties properties, Supplier<MobEffect> effect, int duration, int amplifier, float heal) {
        super(properties);
        this.effect = effect;
        this.duration = duration;
        this.amplifier = amplifier;
        this.heal = heal;
        this.feed = 0;
    }

    public DrinkItem(Item.Properties properties, Supplier<MobEffect> effect, int duration, int amplifier, float heal, int feed) {
        super(properties);
        this.effect = effect;
        this.duration = duration;
        this.amplifier = amplifier;
        this.heal = heal;
        this.feed = feed;
    }

    public void affectConsumer(ItemStack stack, Level worldIn, LivingEntity consumer) {
        consumer.m_7292_(new MobEffectInstance(this.effect.get(), this.duration, this.amplifier));
        if (this.heal > 0.0f) {
            consumer.m_5634_(this.heal);
        }
        if (consumer instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)consumer;
            if (this.feed > 0) {
                player.m_36324_().m_38705_(Math.min(player.m_36324_().m_38702_() + this.feed, 20));
            }
        }
    }
}

