/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.delightful.common.config;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.brdle.delightful.common.item.DelightfulItems;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class DelightfulConfig {
    public static final DelightfulConfig CONFIG;
    public static final ForgeConfigSpec SPEC;
    public final Map<String, ForgeConfigSpec.BooleanValue> stuff;
    public static ForgeConfigSpec.IntValue CHANCE_WILD_SALMONBERRIES;
    public static ForgeConfigSpec.IntValue CHANCE_MINI_MELON;
    public static ForgeConfigSpec.BooleanValue CRAFT_NUT_MILK;
    public static ForgeConfigSpec.BooleanValue COOK_CLOVER_HONEY;
    private static final ImmutableList<String> disabled_by_default_knives;

    DelightfulConfig(ForgeConfigSpec.Builder builder) {
        Collection items = DelightfulItems.ITEMS.getEntries();
        builder.comment(" Let's Configure Delightful");
        this.stuff = new HashMap<String, ForgeConfigSpec.BooleanValue>();
        builder.push("Knives");
        items.stream().map(obj -> obj.getId().m_135815_()).filter(path -> path.contains("_knife")).sorted().forEach(knife -> DelightfulConfig.put(builder, this.stuff, knife, !disabled_by_default_knives.contains(knife)));
        builder.pop();
        builder.push("Cabinets");
        items.stream().map(obj -> obj.getId().m_135815_()).filter(path -> path.contains("_cabinet")).sorted().forEach(cabinet -> DelightfulConfig.put(builder, this.stuff, cabinet, true));
        builder.pop();
        builder.push("Foods and Other Items");
        items.stream().map(obj -> obj.getId().m_135815_()).filter(path -> !path.contains("_knife") && !path.contains("_cabinet") && !path.equals("pizza")).sorted().forEach(not -> DelightfulConfig.put(builder, this.stuff, not, true));
        CRAFT_NUT_MILK = builder.comment("Allow cooking milk from nuts").define("nut_milk", true);
        this.stuff.put("nut_milk", CRAFT_NUT_MILK);
        COOK_CLOVER_HONEY = builder.comment("Allow cooking honey from honey and clovers").define("clover_honey", true);
        this.stuff.put("clover_honey", COOK_CLOVER_HONEY);
        builder.pop();
        builder.push("Generation");
        CHANCE_WILD_SALMONBERRIES = builder.comment("Chance of generating clusters. Smaller value = more frequent.").defineInRange("chance_wild_salmonberries", 30, 0, Integer.MAX_VALUE);
        CHANCE_MINI_MELON = builder.comment("Chance of generating clusters. Smaller value = more frequent.").defineInRange("chance_mini_melon", 30, 0, Integer.MAX_VALUE);
        builder.pop();
    }

    private static void put(ForgeConfigSpec.Builder builder, Map<String, ForgeConfigSpec.BooleanValue> map, String name, boolean def) {
        map.put(name, builder.define(name, def));
    }

    static {
        disabled_by_default_knives = ImmutableList.of((Object)"bone_knife", (Object)"amethyst_knife", (Object)"emerald_knife");
        Pair pair = new ForgeConfigSpec.Builder().configure(DelightfulConfig::new);
        SPEC = (ForgeConfigSpec)pair.getRight();
        CONFIG = (DelightfulConfig)pair.getLeft();
    }
}

