/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.delightful.common;

import java.util.List;
import net.brdle.delightful.common.config.DelightfulConfig;
import net.brdle.delightful.common.item.DelightfulItems;
import net.brdle.delightful.common.item.FurnaceFuelItem;
import net.brdle.delightful.common.world.DelightfulWildCropGeneration;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="delightful")
public class ForgeEvents {
    private static final List<String> portedMods = List.of("coppersdelight", "steelsdelight", "enderitesdelight");

    @SubscribeEvent
    public static void onMissingBlockMappings(RegistryEvent.MissingMappings<Block> e) {
        for (RegistryEvent.MissingMappings.Mapping mapping : e.getAllMappings()) {
            if (!portedMods.contains(mapping.key.m_135827_())) continue;
            ResourceLocation remap = new ResourceLocation("delightful", mapping.key.m_135815_());
            if (ForgeRegistries.BLOCKS.containsKey(remap)) {
                mapping.remap((IForgeRegistryEntry)((Block)ForgeRegistries.BLOCKS.getValue(remap)));
                continue;
            }
            mapping.warn();
        }
    }

    @SubscribeEvent
    public static void onMissingItemMappings(RegistryEvent.MissingMappings<Item> e) {
        for (RegistryEvent.MissingMappings.Mapping mapping : e.getAllMappings()) {
            if (portedMods.contains(mapping.key.m_135827_())) {
                ResourceLocation remap = new ResourceLocation("delightful", mapping.key.m_135815_());
                if (ForgeRegistries.ITEMS.containsKey(remap)) {
                    mapping.remap((IForgeRegistryEntry)((Item)ForgeRegistries.ITEMS.getValue(remap)));
                    continue;
                }
                mapping.warn();
                continue;
            }
            if (!mapping.key.m_135827_().equals("delightful") || !mapping.key.m_135815_().equals("salmonberry")) continue;
            mapping.remap((IForgeRegistryEntry)((Item)DelightfulItems.SALMONBERRIES.get()));
        }
    }

    private static void veg(BiomeGenerationSettingsBuilder b, Holder<PlacedFeature> feature) {
        b.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, feature);
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent e) {
        switch (e.getCategory()) {
            case FOREST: {
                if ((Integer)DelightfulConfig.CHANCE_WILD_SALMONBERRIES.get() <= 0) break;
                ForgeEvents.veg(e.getGeneration(), DelightfulWildCropGeneration.PATCH_WILD_SALMONBERRIES);
                break;
            }
            case PLAINS: {
                if ((Integer)DelightfulConfig.CHANCE_MINI_MELON.get() <= 0) break;
                ForgeEvents.veg(e.getGeneration(), DelightfulWildCropGeneration.PATCH_MINI_MELON);
            }
        }
    }

    @SubscribeEvent
    public static void burnTime(FurnaceFuelBurnTimeEvent e) {
        Item item = e.getItemStack().m_41720_();
        if (item instanceof FurnaceFuelItem) {
            FurnaceFuelItem fuel = (FurnaceFuelItem)item;
            e.setBurnTime(fuel.getFuelTime());
        }
    }

    @SubscribeEvent
    public static void fieryToolSetFire(LivingAttackEvent e) {
        LivingEntity living;
        Entity entity = e.getSource().m_7639_();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21205_().m_150930_((Item)DelightfulItems.FIERY_KNIFE.get()) && !e.getEntity().m_5825_()) {
            e.getEntity().m_20254_(1);
        }
    }

    @SubscribeEvent
    public static void onKnightmetalToolDamage(LivingHurtEvent e) {
        LivingEntity living;
        ItemStack weapon;
        Entity entity;
        LivingEntity target = e.getEntityLiving();
        if (!target.m_183503_().m_5776_() && (entity = e.getSource().m_7640_()) instanceof LivingEntity && !(weapon = (living = (LivingEntity)entity).m_21205_()).m_41619_() && target.m_21230_() > 0 && weapon.m_150930_((Item)DelightfulItems.KNIGHTMETAL_KNIFE.get())) {
            if (target.m_21207_() > 0.0f) {
                int moreBonus = (int)(2.0f * target.m_21207_());
                e.setAmount(e.getAmount() + (float)moreBonus);
            } else {
                e.setAmount(e.getAmount() + 2.0f);
            }
            ((ServerLevel)target.m_183503_()).m_7726_().m_8394_((Entity)target, (Packet)new ClientboundAnimatePacket((Entity)target, 5));
        }
    }
}

