/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.render.fluid;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidAttributes;

public class EmbeddiumFluidSpriteCache {
    private final TextureAtlasSprite[] sprites = new TextureAtlasSprite[3];
    private final Object2ObjectOpenHashMap<ResourceLocation, TextureAtlasSprite> spriteCache = new Object2ObjectOpenHashMap();

    private TextureAtlasSprite getTexture(ResourceLocation identifier) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)this.spriteCache.get((Object)identifier);
        if (sprite == null) {
            sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(identifier);
            this.spriteCache.put((Object)identifier, (Object)sprite);
        }
        return sprite;
    }

    public TextureAtlasSprite[] getSprites(BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        FluidAttributes attributes = fluidState.m_76152_().getAttributes();
        this.sprites[0] = this.getTexture(attributes.getStillTexture(world, pos));
        this.sprites[1] = this.getTexture(attributes.getFlowingTexture(world, pos));
        ResourceLocation overlay = attributes.getOverlayTexture();
        this.sprites[2] = overlay != null ? this.getTexture(overlay) : null;
        return this.sprites;
    }
}

