/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.render;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.material.FluidState;

public class EmbeddiumRenderLayerCache {
    private static final boolean DISABLE_CACHE = Boolean.getBoolean("embeddium.disableRenderLayerCache");
    private static final Reference2ReferenceOpenHashMap<RenderType, ImmutableList<RenderType>> SINGLE_LAYERS = new Reference2ReferenceOpenHashMap();
    private volatile Reference2ReferenceOpenHashMap<StateHolder<?, ?>, ImmutableList<RenderType>> stateToLayerMap;

    public EmbeddiumRenderLayerCache() {
        this.invalidate();
    }

    public <O, S, H extends StateHolder<O, S>> List<RenderType> forState(H state) {
        if (DISABLE_CACHE) {
            return EmbeddiumRenderLayerCache.generateList(state);
        }
        ImmutableList<RenderType> list = (ImmutableList<RenderType>)this.stateToLayerMap.get(state);
        if (list == null) {
            list = this.createList(state);
        }
        return list;
    }

    private static <O, S, H extends StateHolder<O, S>> List<RenderType> generateList(H state) {
        ArrayList<RenderType> foundLayers = new ArrayList<RenderType>(2);
        if (state instanceof BlockState) {
            BlockState blockState = (BlockState)state;
            for (RenderType layer : RenderType.m_110506_()) {
                if (!ItemBlockRenderTypes.canRenderInLayer((BlockState)blockState, (RenderType)layer)) continue;
                foundLayers.add(layer);
            }
        } else if (state instanceof FluidState) {
            FluidState fluidState = (FluidState)state;
            for (RenderType layer : RenderType.m_110506_()) {
                if (!ItemBlockRenderTypes.canRenderInLayer((FluidState)fluidState, (RenderType)layer)) continue;
                foundLayers.add(layer);
            }
        } else {
            throw new IllegalArgumentException("Unexpected type of state received: " + state.getClass().getName());
        }
        return foundLayers;
    }

    private <O, S, H extends StateHolder<O, S>> ImmutableList<RenderType> createList(H state) {
        ImmutableList layerList;
        List<RenderType> foundLayers = EmbeddiumRenderLayerCache.generateList(state);
        if (foundLayers.isEmpty()) {
            layerList = ImmutableList.of();
        } else if (foundLayers.size() == 1) {
            layerList = (ImmutableList)SINGLE_LAYERS.get((Object)foundLayers.get(0));
            Objects.requireNonNull(layerList);
        } else {
            layerList = ImmutableList.copyOf(foundLayers);
        }
        this.stateToLayerMap.put(state, (Object)layerList);
        return layerList;
    }

    public void invalidate() {
        if (this.stateToLayerMap == null || this.stateToLayerMap.size() > 0) {
            this.stateToLayerMap = new Reference2ReferenceOpenHashMap();
        }
    }

    static {
        for (RenderType layer : RenderType.m_110506_()) {
            SINGLE_LAYERS.put((Object)layer, (Object)ImmutableList.of((Object)layer));
        }
        if (DISABLE_CACHE) {
            SodiumClientMod.logger().warn("Render layer cache is disabled, performance will be affected.");
        }
    }
}

