/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.gui;

import com.google.common.base.Strings;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ForgeIngameGui.class})
public abstract class MixinDebugHud
extends Gui {
    @Shadow
    private Font font;

    @Shadow
    protected abstract void post(RenderGameOverlayEvent.ElementType var1, PoseStack var2);

    public MixinDebugHud(Minecraft p_93005_) {
        super(p_93005_);
    }

    @Inject(method={"renderHUDText"}, at={@At(value="INVOKE", target="Ljava/util/ArrayList;iterator()Ljava/util/Iterator;", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true, remap=false)
    private void embeddium$renderTextFast(int width, int height, PoseStack poseStack, CallbackInfo ci, ArrayList<String> listL, ArrayList<String> listR, RenderGameOverlayEvent.Text event) {
        ci.cancel();
        this.renderForgeList(poseStack, listL, false);
        this.renderForgeList(poseStack, listR, true);
        this.f_92986_.m_91307_().m_7238_();
        this.post(RenderGameOverlayEvent.ElementType.TEXT, poseStack);
    }

    private void renderForgeList(PoseStack matrixStack, List<String> list, boolean right) {
        this.renderBackdrop(matrixStack, list, right);
        this.renderStrings(matrixStack, list, right);
    }

    private void renderStrings(PoseStack matrixStack, List<String> list, boolean right) {
        MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        Matrix4f positionMatrix = matrixStack.m_85850_().m_85861_();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (Strings.isNullOrEmpty((String)string)) continue;
            int height = 9;
            int width = this.font.m_92895_(string);
            float x1 = right ? (float)(this.f_92986_.m_91268_().m_85445_() - 2 - width) : 2.0f;
            float y1 = 2 + height * i;
            this.font.m_92822_(string, x1, y1, 0xE0E0E0, false, positionMatrix, (MultiBufferSource)immediate, false, 0, 0xF000F0, this.font.m_92718_());
        }
        immediate.m_109911_();
    }

    private void renderBackdrop(PoseStack matrixStack, List<String> list, boolean right) {
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        int color = -1873784752;
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float h = (float)(color >> 8 & 0xFF) / 255.0f;
        float k = (float)(color & 0xFF) / 255.0f;
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (Strings.isNullOrEmpty((String)string)) continue;
            int height = 9;
            int width = this.font.m_92895_(string);
            int x = right ? this.f_92986_.m_91268_().m_85445_() - 2 - width : 2;
            int y = 2 + height * i;
            float x1 = x - 1;
            float y1 = y - 1;
            float x2 = x + width + 1;
            float y2 = y + height - 1;
            bufferBuilder.m_85982_(matrix, x1, y2, 0.0f).m_85950_(g, h, k, f).m_5752_();
            bufferBuilder.m_85982_(matrix, x2, y2, 0.0f).m_85950_(g, h, k, f).m_5752_();
            bufferBuilder.m_85982_(matrix, x2, y1, 0.0f).m_85950_(g, h, k, f).m_5752_();
            bufferBuilder.m_85982_(matrix, x1, y1, 0.0f).m_85950_(g, h, k, f).m_5752_();
        }
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }
}

