/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import me.jellysquid.mods.sodium.client.compat.modernui.MuiGuiScaleHook;
import me.jellysquid.mods.sodium.client.gl.arena.staging.MappedStagingBuffer;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpl;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.binding.compat.VanillaBooleanOptionBinding;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.gui.options.control.CyclingControl;
import me.jellysquid.mods.sodium.client.gui.options.control.SliderControl;
import me.jellysquid.mods.sodium.client.gui.options.control.TickBoxControl;
import me.jellysquid.mods.sodium.client.gui.options.storage.MinecraftOptionsStorage;
import me.jellysquid.mods.sodium.client.gui.options.storage.SodiumOptionsStorage;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuilder;
import net.minecraft.client.AmbientOcclusionStatus;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.CycleOption;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.embeddedt.embeddium.render.ShaderModBridge;

public class SodiumGameOptionPages {
    private static final SodiumOptionsStorage sodiumOpts = new SodiumOptionsStorage();
    private static final MinecraftOptionsStorage vanillaOpts = new MinecraftOptionsStorage();

    public static OptionPage general() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)new TranslatableComponent("options.renderDistance")).setTooltip((Component)new TranslatableComponent("sodium.options.view_distance.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 2, 32, 1, ControlValueFormatter.translateVariable("options.chunks"))).setBinding((options, value) -> {
            options.f_92106_ = value;
        }, options -> options.f_92106_).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)new TranslatableComponent("options.simulationDistance")).setTooltip((Component)new TranslatableComponent("sodium.options.simulation_distance.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 5, 32, 1, ControlValueFormatter.translateVariable("options.chunks"))).setBinding((options, value) -> {
            options.f_193768_ = value;
        }, options -> options.f_193768_).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)new TranslatableComponent("options.gamma")).setTooltip((Component)new TranslatableComponent("sodium.options.brightness.tooltip")).setControl(opt -> new SliderControl((Option<Integer>)opt, 0, 100, 1, ControlValueFormatter.brightness())).setBinding((opts, value) -> {
            opts.f_92071_ = (double)value.intValue() * 0.01;
        }, opts -> (int)(opts.f_92071_ / 0.01)).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)new TranslatableComponent("options.guiScale")).setTooltip((Component)new TranslatableComponent("sodium.options.gui_scale.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 0, MuiGuiScaleHook.getMaxGuiScale(), 1, ControlValueFormatter.guiScale())).setBinding((opts, value) -> {
            opts.f_92072_ = value;
            Minecraft client = Minecraft.m_91087_();
            client.m_5741_();
        }, opts -> opts.f_92072_).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((Component)new TranslatableComponent("options.fullscreen")).setTooltip((Component)new TranslatableComponent("sodium.options.fullscreen.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.f_92052_ = value;
            Minecraft client = Minecraft.m_91087_();
            Window window = client.m_91268_();
            if (window != null && window.m_85440_() != opts.f_92052_) {
                window.m_85438_();
                opts.f_92052_ = window.m_85440_();
            }
        }, opts -> opts.f_92052_).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((Component)new TranslatableComponent("options.vsync")).setTooltip((Component)new TranslatableComponent("sodium.options.v_sync.tooltip")).setControl(TickBoxControl::new).setBinding(new VanillaBooleanOptionBinding((CycleOption<Boolean>)net.minecraft.client.Option.f_91638_)).setImpact(OptionImpact.VARIES).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)new TranslatableComponent("options.framerateLimit")).setTooltip((Component)new TranslatableComponent("sodium.options.fps_limit.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 5, 260, 5, ControlValueFormatter.fpsLimit())).setBinding((opts, value) -> {
            opts.f_92113_ = value;
            Minecraft.m_91087_().m_91268_().m_85380_(value.intValue());
        }, opts -> opts.f_92113_).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((Component)new TranslatableComponent("options.viewBobbing")).setTooltip((Component)new TranslatableComponent("sodium.options.view_bobbing.tooltip")).setControl(TickBoxControl::new).setBinding(new VanillaBooleanOptionBinding((CycleOption<Boolean>)net.minecraft.client.Option.f_91650_)).build()).add(OptionImpl.createBuilder(AttackIndicatorStatus.class, vanillaOpts).setName((Component)new TranslatableComponent("options.attackIndicator")).setTooltip((Component)new TranslatableComponent("sodium.options.attack_indicator.tooltip")).setControl(opts -> new CyclingControl<AttackIndicatorStatus>((Option<AttackIndicatorStatus>)opts, AttackIndicatorStatus.class, new Component[]{new TranslatableComponent("options.off"), new TranslatableComponent("options.attack.crosshair"), new TranslatableComponent("options.attack.hotbar")})).setBinding((opts, value) -> {
            opts.f_92029_ = value;
        }, opts -> opts.f_92029_).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((Component)new TranslatableComponent("options.autosaveIndicator")).setTooltip((Component)new TranslatableComponent("sodium.options.autosave_indicator.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.f_193763_ = value;
        }, opts -> opts.f_193763_).build()).build());
        return new OptionPage((Component)new TranslatableComponent("stat.generalButton"), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage quality() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(GraphicsStatus.class, vanillaOpts).setName((Component)new TranslatableComponent("options.graphics")).setTooltip((Component)new TranslatableComponent("sodium.options.graphics_quality.tooltip")).setControl(option -> new CyclingControl<GraphicsStatus>((Option<GraphicsStatus>)option, GraphicsStatus.class, new Component[]{new TranslatableComponent("options.graphics.fast"), new TranslatableComponent("options.graphics.fancy"), new TranslatableComponent("options.graphics.fabulous")})).setBinding((opts, value) -> {
            opts.f_92115_ = value;
        }, opts -> opts.f_92115_).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(CloudStatus.class, vanillaOpts).setName((Component)new TranslatableComponent("options.renderClouds")).setTooltip((Component)new TranslatableComponent("sodium.options.clouds_quality.tooltip")).setControl(option -> new CyclingControl<CloudStatus>((Option<CloudStatus>)option, CloudStatus.class, new Component[]{new TranslatableComponent("options.off"), new TranslatableComponent("options.clouds.fast"), new TranslatableComponent("options.clouds.fancy")})).setBinding((opts, value) -> {
            RenderTarget framebuffer;
            opts.f_92114_ = value;
            if (Minecraft.m_91085_() && (framebuffer = Minecraft.m_91087_().f_91060_.m_109832_()) != null) {
                framebuffer.m_83954_(Minecraft.f_91002_);
            }
        }, opts -> opts.f_92114_).setImpact(OptionImpact.LOW).build()).add(OptionImpl.createBuilder(SodiumGameOptions.GraphicsQuality.class, sodiumOpts).setName((Component)new TranslatableComponent("soundCategory.weather")).setTooltip((Component)new TranslatableComponent("sodium.options.weather_quality.tooltip")).setControl(option -> new CyclingControl<SodiumGameOptions.GraphicsQuality>((Option<SodiumGameOptions.GraphicsQuality>)option, SodiumGameOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.weatherQuality = value;
        }, opts -> opts.quality.weatherQuality).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(SodiumGameOptions.GraphicsQuality.class, sodiumOpts).setName((Component)new TranslatableComponent("sodium.options.leaves_quality.name")).setTooltip((Component)new TranslatableComponent("sodium.options.leaves_quality.tooltip")).setControl(option -> new CyclingControl<SodiumGameOptions.GraphicsQuality>((Option<SodiumGameOptions.GraphicsQuality>)option, SodiumGameOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.leavesQuality = value;
        }, opts -> opts.quality.leavesQuality).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(ParticleStatus.class, vanillaOpts).setName((Component)new TranslatableComponent("options.particles")).setTooltip((Component)new TranslatableComponent("sodium.options.particle_quality.tooltip")).setControl(option -> new CyclingControl<ParticleStatus>((Option<ParticleStatus>)option, ParticleStatus.class, new Component[]{new TranslatableComponent("options.particles.all"), new TranslatableComponent("options.particles.decreased"), new TranslatableComponent("options.particles.minimal")})).setBinding((opts, value) -> {
            opts.f_92073_ = value;
        }, opts -> opts.f_92073_).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((Component)new TranslatableComponent("options.ao")).setTooltip((Component)new TranslatableComponent("sodium.options.smooth_lighting.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.f_92116_ = value != false ? AmbientOcclusionStatus.MAX : AmbientOcclusionStatus.OFF;
        }, opts -> opts.f_92116_ == AmbientOcclusionStatus.MAX).setImpact(OptionImpact.LOW).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)new TranslatableComponent("options.biomeBlendRadius")).setTooltip((Component)new TranslatableComponent("sodium.options.biome_blend.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 0, 7, 1, ControlValueFormatter.biomeBlend())).setBinding((opts, value) -> {
            opts.f_92032_ = value;
        }, opts -> opts.f_92032_).setImpact(OptionImpact.LOW).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)new TranslatableComponent("options.entityDistanceScaling")).setTooltip((Component)new TranslatableComponent("sodium.options.entity_distance.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 50, 500, 25, ControlValueFormatter.percentage())).setBinding((opts, value) -> {
            opts.f_92112_ = (float)value.intValue() / 100.0f;
        }, opts -> Math.round(opts.f_92112_ * 100.0f)).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((Component)new TranslatableComponent("options.entityShadows")).setTooltip((Component)new TranslatableComponent("sodium.options.entity_shadows.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.f_92042_ = value;
        }, opts -> opts.f_92042_).setImpact(OptionImpact.LOW).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)new TranslatableComponent("sodium.options.vignette.name")).setTooltip((Component)new TranslatableComponent("sodium.options.vignette.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.quality.enableVignette = value;
        }, opts -> opts.quality.enableVignette).setImpact(OptionImpact.LOW).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)new TranslatableComponent("options.mipmapLevels")).setTooltip((Component)new TranslatableComponent("sodium.options.mipmap_levels.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 0, 4, 1, ControlValueFormatter.multiplier())).setBinding((opts, value) -> {
            opts.f_92027_ = value;
        }, opts -> opts.f_92027_).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_ASSET_RELOAD).build()).build());
        return new OptionPage((Component)new TranslatableComponent("sodium.options.pages.quality"), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage performance() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, sodiumOpts).setName((Component)new TranslatableComponent("sodium.options.chunk_update_threads.name")).setTooltip((Component)new TranslatableComponent("sodium.options.chunk_update_threads.tooltip")).setControl(o -> new SliderControl((Option<Integer>)o, 0, ChunkBuilder.getMaxThreadCount(), 1, ControlValueFormatter.quantityOrDisabled("threads", "Default"))).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.performance.chunkBuilderThreads = value;
        }, opts -> opts.performance.chunkBuilderThreads).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)new TranslatableComponent("sodium.options.always_defer_chunk_updates.name")).setTooltip((Component)new TranslatableComponent("sodium.options.always_defer_chunk_updates.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.performance.alwaysDeferChunkUpdates = value;
        }, opts -> opts.performance.alwaysDeferChunkUpdates).setFlags(OptionFlag.REQUIRES_RENDERER_UPDATE).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)new TranslatableComponent("sodium.options.use_block_face_culling.name")).setTooltip((Component)new TranslatableComponent("sodium.options.use_block_face_culling.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.performance.useBlockFaceCulling = value;
        }, opts -> opts.performance.useBlockFaceCulling).setFlags(OptionFlag.REQUIRES_RENDERER_UPDATE).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)new TranslatableComponent("sodium.options.use_compact_vertex_format.name")).setTooltip((Component)new TranslatableComponent("sodium.options.use_compact_vertex_format.tooltip")).setControl(TickBoxControl::new).setEnabled(!ShaderModBridge.areShadersEnabled()).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.performance.useCompactVertexFormat = value;
        }, opts -> opts.performance.useCompactVertexFormat).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)new TranslatableComponent("sodium.options.use_fog_occlusion.name")).setTooltip((Component)new TranslatableComponent("sodium.options.use_fog_occlusion.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.performance.useFogOcclusion = value;
        }, opts -> opts.performance.useFogOcclusion).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_UPDATE).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)new TranslatableComponent("sodium.options.use_entity_culling.name")).setTooltip((Component)new TranslatableComponent("sodium.options.use_entity_culling.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.performance.useEntityCulling = value;
        }, opts -> opts.performance.useEntityCulling).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)new TranslatableComponent("sodium.options.animate_only_visible_textures.name")).setTooltip((Component)new TranslatableComponent("sodium.options.animate_only_visible_textures.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.performance.animateOnlyVisibleTextures = value;
        }, opts -> opts.performance.animateOnlyVisibleTextures).setFlags(OptionFlag.REQUIRES_RENDERER_UPDATE).build()).build());
        return new OptionPage((Component)new TranslatableComponent("sodium.options.pages.performance"), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage advanced() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(SodiumGameOptions.ArenaMemoryAllocator.class, sodiumOpts).setName((Component)new TranslatableComponent("sodium.options.chunk_memory_allocator.name")).setTooltip((Component)new TranslatableComponent("sodium.options.chunk_memory_allocator.tooltip")).setControl(option -> new CyclingControl<SodiumGameOptions.ArenaMemoryAllocator>((Option<SodiumGameOptions.ArenaMemoryAllocator>)option, SodiumGameOptions.ArenaMemoryAllocator.class)).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.advanced.arenaMemoryAllocator = value;
        }, opts -> opts.advanced.arenaMemoryAllocator).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)new TranslatableComponent("sodium.options.use_persistent_mapping.name")).setTooltip((Component)new TranslatableComponent("sodium.options.use_persistent_mapping.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setEnabled(MappedStagingBuffer.isSupported(RenderDevice.INSTANCE)).setBinding((opts, value) -> {
            opts.advanced.useAdvancedStagingBuffers = value;
        }, opts -> opts.advanced.useAdvancedStagingBuffers).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, sodiumOpts).setName((Component)new TranslatableComponent("sodium.options.cpu_render_ahead_limit.name")).setTooltip((Component)new TranslatableComponent("sodium.options.cpu_render_ahead_limit.tooltip")).setControl(opt -> new SliderControl((Option<Integer>)opt, 0, 9, 1, ControlValueFormatter.translateVariable("sodium.options.cpu_render_ahead_limit.value"))).setBinding((opts, value) -> {
            opts.advanced.cpuRenderAheadLimit = value;
        }, opts -> opts.advanced.cpuRenderAheadLimit).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)new TranslatableComponent("sodium.options.allow_direct_memory_access.name")).setTooltip((Component)new TranslatableComponent("sodium.options.allow_direct_memory_access.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.advanced.allowDirectMemoryAccess = value;
        }, opts -> opts.advanced.allowDirectMemoryAccess).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)new TranslatableComponent("sodium.options.translucent_face_sorting.name")).setTooltip((Component)new TranslatableComponent("sodium.options.translucent_face_sorting.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.VARIES).setBinding((opts, value) -> {
            opts.performance.useTranslucentFaceSorting = value;
        }, opts -> opts.performance.useTranslucentFaceSorting).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        return new OptionPage((Component)new TranslatableComponent("sodium.options.pages.advanced"), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }
}

