/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items.util.fluid;

import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import reliquary.init.ModItems;
import reliquary.items.EmperorChaliceItem;

public class FluidHandlerEmperorChalice
implements IFluidHandlerItem,
ICapabilityProvider {
    public static final FluidStack BUCKET_OF_WATER = new FluidStack((Fluid)Fluids.f_76193_, 1000);
    private final ItemStack chalice;

    public FluidHandlerEmperorChalice(ItemStack chalice) {
        this.chalice = chalice;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this));
    }

    public ItemStack getContainer() {
        return this.chalice;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return BUCKET_OF_WATER;
    }

    public int getTankCapacity(int tank) {
        return 1000;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return stack.getFluid() == Fluids.f_76193_;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!((EmperorChaliceItem)ModItems.EMPEROR_CHALICE.get()).isEnabled(this.chalice) || resource.isEmpty() || resource.getFluid() != Fluids.f_76193_) {
            return 0;
        }
        return resource.getAmount();
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (((EmperorChaliceItem)ModItems.EMPEROR_CHALICE.get()).isEnabled(this.chalice) || resource.isEmpty() || resource.getFluid() != Fluids.f_76193_) {
            return FluidStack.EMPTY;
        }
        return new FluidStack((Fluid)Fluids.f_76193_, Math.min(1000, resource.getAmount()));
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (((EmperorChaliceItem)ModItems.EMPEROR_CHALICE.get()).isEnabled(this.chalice)) {
            return FluidStack.EMPTY;
        }
        return new FluidStack((Fluid)Fluids.f_76193_, Math.min(1000, maxDrain));
    }
}

