/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import reliquary.entities.EnderStaffProjectileEntity;
import reliquary.init.ModBlocks;
import reliquary.items.ToggleableItem;
import reliquary.items.util.FilteredBigItemStack;
import reliquary.items.util.FilteredItemHandlerProvider;
import reliquary.items.util.FilteredItemStackHandler;
import reliquary.items.util.IScrollableItem;
import reliquary.reference.Settings;
import reliquary.util.LanguageHelper;
import reliquary.util.NBTHelper;

public class EnderStaffItem
extends ToggleableItem
implements IScrollableItem {
    private static final String DIMENSION_TAG = "dimensionID";
    private static final String NODE_X_TAG = "nodeX";
    private static final String NODE_Y_TAG = "nodeY";
    private static final String NODE_Z_TAG = "nodeZ";

    public EnderStaffItem() {
        super(new Item.Properties().m_41487_(1).setNoRepair().m_41497_(Rarity.EPIC));
    }

    private int getEnderStaffPearlCost() {
        return (Integer)Settings.COMMON.items.enderStaff.enderPearlCastCost.get();
    }

    private int getEnderStaffNodeWarpCost() {
        return (Integer)Settings.COMMON.items.enderStaff.enderPearlNodeWarpCost.get();
    }

    private int getEnderPearlWorth() {
        return (Integer)Settings.COMMON.items.enderStaff.enderPearlWorth.get();
    }

    private int getEnderPearlLimit() {
        return (Integer)Settings.COMMON.items.enderStaff.enderPearlLimit.get();
    }

    private int getNodeWarpCastTime() {
        return (Integer)Settings.COMMON.items.enderStaff.nodeWarpCastTime.get();
    }

    public Mode getMode(ItemStack stack) {
        return NBTHelper.getEnumConstant(stack, "mode", Mode::fromName).orElse(Mode.CAST);
    }

    private void setMode(ItemStack stack, Mode mode) {
        NBTHelper.putString("mode", stack, mode.m_7912_());
    }

    private void cycleMode(ItemStack stack, boolean next) {
        if (next) {
            this.setMode(stack, this.getMode(stack).next());
        } else {
            this.setMode(stack, this.getMode(stack).previous());
        }
    }

    @Override
    public InteractionResult onMouseScrolled(ItemStack stack, Player player, double scrollDelta) {
        if (player.f_19853_.f_46443_) {
            return InteractionResult.PASS;
        }
        this.cycleMode(stack, scrollDelta > 0.0);
        return InteractionResult.SUCCESS;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FilteredItemHandlerProvider(Collections.singletonList(new FilteredItemStackHandler.RemovableStack(new FilteredBigItemStack(Items.f_42584_, (int)((Integer)Settings.COMMON.items.enderStaff.enderPearlLimit.get()), (int)((Integer)Settings.COMMON.items.enderStaff.enderPearlWorth.get())), false)));
    }

    public void m_6883_(ItemStack staff, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.f_46443_ || world.m_46467_() % 10L != 0L) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!this.isEnabled(staff)) {
            return;
        }
        int pearlCharge = this.getPearlCount(staff);
        this.consumeAndCharge(player, this.getEnderPearlLimit() - pearlCharge, this.getEnderPearlWorth(), Items.f_42584_, 16, (int chargeToAdd) -> this.setPearlCount(staff, pearlCharge + chargeToAdd));
    }

    private void setPearlCount(ItemStack stack, int count) {
        stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(itemHandler -> {
            if (!(itemHandler instanceof FilteredItemStackHandler)) {
                return;
            }
            FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
            filteredHandler.setTotalAmount(0, count);
        });
    }

    private int getPearlCount(ItemStack staff) {
        return this.getPearlCount(staff, false);
    }

    public int getPearlCount(ItemStack staff, boolean isClient) {
        if (isClient) {
            return NBTHelper.getInt("count", staff);
        }
        return staff.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).map(itemHandler -> {
            if (!(itemHandler instanceof FilteredItemStackHandler)) {
                return 0;
            }
            FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
            return filteredHandler.getTotalAmount(0);
        }).orElse(0);
    }

    public void onUsingTick(ItemStack stack, LivingEntity entityLivingBase, int unadjustedCount) {
        if (!(entityLivingBase instanceof Player)) {
            return;
        }
        Player player = (Player)entityLivingBase;
        for (int particles = 0; particles < 2; ++particles) {
            player.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, player.m_20185_(), player.m_20188_(), player.m_20189_(), player.f_19853_.f_46441_.nextGaussian(), player.f_19853_.f_46441_.nextGaussian(), player.f_19853_.f_46441_.nextGaussian());
        }
        if (unadjustedCount == 1) {
            player.m_21253_();
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack stack) {
        return this.getNodeWarpCastTime();
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof Player)) {
            return;
        }
        Player player = (Player)entityLiving;
        if (timeLeft == 1) {
            this.doWraithNodeWarpCheck(stack, player.f_19853_, player);
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_6144_()) {
            if (this.getMode(stack) == Mode.CAST || this.getMode(stack) == Mode.LONG_CAST) {
                if (this.getPearlCount(stack) < this.getEnderStaffPearlCost() && !player.m_7500_()) {
                    return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
                }
                this.shootEnderStaffProjectile(world, player, hand, stack);
            } else {
                player.m_6672_(hand);
            }
        }
        return super.m_7203_(world, player, hand);
    }

    private void shootEnderStaffProjectile(Level world, Player player, InteractionHand hand, ItemStack stack) {
        player.m_6674_(hand);
        player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_11857_, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.m_5822_().nextFloat() * 0.4f + 0.8f));
        if (!player.f_19853_.f_46443_) {
            EnderStaffProjectileEntity enderStaffProjectile = new EnderStaffProjectileEntity(player.f_19853_, player, this.getMode(stack) != Mode.LONG_CAST);
            enderStaffProjectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
            player.f_19853_.m_7967_((Entity)enderStaffProjectile);
            if (!player.m_7500_()) {
                this.setPearlCount(stack, this.getPearlCount(stack) - this.getEnderStaffPearlCost());
            }
        }
    }

    private void doWraithNodeWarpCheck(ItemStack stack, Level world, Player player) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || this.getPearlCount(stack) < this.getEnderStaffNodeWarpCost() && !player.m_7500_()) {
            return;
        }
        if (!tag.m_128461_(DIMENSION_TAG).equals(this.getDimension(world))) {
            if (!world.f_46443_) {
                player.m_6352_((Component)new TextComponent(ChatFormatting.DARK_RED + "Out of range!"), Util.f_137441_);
            }
            return;
        }
        BlockPos wraithNodePos = new BlockPos(tag.m_128451_(NODE_X_TAG + this.getDimension(world)), tag.m_128451_(NODE_Y_TAG + this.getDimension(world)), tag.m_128451_(NODE_Z_TAG + this.getDimension(world)));
        if (world.m_8055_(wraithNodePos).m_60734_() == ModBlocks.WRAITH_NODE.get() && this.canTeleport(world, wraithNodePos)) {
            this.teleportPlayer(world, wraithNodePos, player);
            if (!player.m_7500_() && !player.f_19853_.f_46443_) {
                this.setPearlCount(stack, this.getPearlCount(stack) - this.getEnderStaffNodeWarpCost());
            }
            return;
        }
        if (tag.m_128441_(DIMENSION_TAG)) {
            tag.m_128473_(DIMENSION_TAG);
            tag.m_128473_(NODE_X_TAG);
            tag.m_128473_(NODE_Y_TAG);
            tag.m_128473_(NODE_Z_TAG);
            if (!world.f_46443_) {
                player.m_6352_((Component)new TextComponent(ChatFormatting.DARK_RED + "Node doesn't exist!"), Util.f_137441_);
            } else {
                player.m_5496_(SoundEvents.f_11900_, 1.0f, 1.0f);
            }
        }
    }

    private boolean canTeleport(Level world, BlockPos pos) {
        BlockPos up = pos.m_7494_();
        return world.m_46859_(up) && world.m_46859_(up.m_7494_());
    }

    private void teleportPlayer(Level world, BlockPos pos, Player player) {
        player.m_6021_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.875, (double)pos.m_123343_() + 0.5);
        player.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        for (int particles = 0; particles < 2; ++particles) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123760_, player.m_20185_(), player.m_20188_(), player.m_20189_(), world.f_46441_.nextGaussian(), world.f_46441_.nextGaussian(), world.f_46441_.nextGaussian());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack staff, @Nullable Level world, List<Component> tooltip) {
        String charge = Integer.toString(this.getPearlCount(staff, true));
        String phrase = "Currently bound to ";
        Object position = "";
        if (staff.m_41783_() != null && !staff.m_41783_().m_128461_(DIMENSION_TAG).equals(this.getDimension(world))) {
            phrase = "Out of range!";
        } else {
            position = staff.m_41783_() != null && staff.m_41783_().m_128441_(NODE_X_TAG + this.getDimension(world)) && staff.m_41783_().m_128441_(NODE_Y_TAG + this.getDimension(world)) && staff.m_41783_().m_128441_(NODE_Z_TAG + this.getDimension(world)) ? "X: " + staff.m_41783_().m_128451_(NODE_X_TAG + this.getDimension(world)) + " Y: " + staff.m_41783_().m_128451_(NODE_Y_TAG + this.getDimension(world)) + " Z: " + staff.m_41783_().m_128451_(NODE_Z_TAG + this.getDimension(world)) : "nowhere.";
        }
        LanguageHelper.formatTooltip(this.m_5524_() + ".tooltip2", Map.of("phrase", phrase, "position", position, "charge", charge), tooltip);
        if (this.isEnabled(staff)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", Map.of("item", ChatFormatting.GREEN + Items.f_42584_.m_7626_(new ItemStack((ItemLike)Items.f_42584_)).toString()), tooltip);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, tooltip);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public InteractionResult m_6225_(UseOnContext itemUseContext) {
        ItemStack stack = itemUseContext.m_43722_();
        Level world = itemUseContext.m_43725_();
        BlockPos pos = itemUseContext.m_8083_();
        if (!(stack.m_41783_() != null && stack.m_41783_().m_128441_(DIMENSION_TAG) || world.m_8055_(pos).m_60734_() != ModBlocks.WRAITH_NODE.get())) {
            this.setWraithNode(stack, pos, this.getDimension(world));
            Player player = itemUseContext.m_43723_();
            if (player != null) {
                player.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
            for (int particles = 0; particles < 12; ++particles) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123760_, (double)pos.m_123341_() + world.f_46441_.nextDouble(), (double)pos.m_123342_() + world.f_46441_.nextDouble(), (double)pos.m_123343_() + world.f_46441_.nextDouble(), world.f_46441_.nextGaussian(), world.f_46441_.nextGaussian(), world.f_46441_.nextGaussian());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private String getDimension(@Nullable Level world) {
        return world != null ? world.m_46472_().getRegistryName().toString() : Level.f_46428_.getRegistryName().toString();
    }

    private void setWraithNode(ItemStack eye, BlockPos pos, String dimension) {
        NBTHelper.putInt(NODE_X_TAG + dimension, eye, pos.m_123341_());
        NBTHelper.putInt(NODE_Y_TAG + dimension, eye, pos.m_123342_());
        NBTHelper.putInt(NODE_Z_TAG + dimension, eye, pos.m_123343_());
        NBTHelper.putString(DIMENSION_TAG, eye, dimension);
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack staff) {
        CompoundTag nbt = super.getShareTag(staff);
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128405_("count", this.getPearlCount(staff));
        return nbt;
    }

    public static enum Mode implements StringRepresentable
    {
        CAST("cast"),
        LONG_CAST("long_cast"),
        NODE_WARP("node_warp");

        private final String name;
        private static final Map<String, Mode> NAME_VALUES;
        private static final Mode[] VALUES;

        private Mode(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public Mode next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public Mode previous() {
            return VALUES[Math.floorMod(this.ordinal() - 1, VALUES.length)];
        }

        public static Mode fromName(String name) {
            return NAME_VALUES.getOrDefault(name, CAST);
        }

        static {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Mode value : Mode.values()) {
                builder.put((Object)value.m_7912_(), (Object)value);
            }
            NAME_VALUES = builder.build();
            VALUES = Mode.values();
        }
    }
}

