/*
 * Decompiled with CFR 0.152.
 */
package reliquary.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import reliquary.init.ModBlocks;
import reliquary.init.ModItems;
import reliquary.init.RandomChanceLootingSeveringCondition;

public class LootInjectProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    LootInjectProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(HashCache cache) throws IOException {
        HashMap<ResourceLocation, LootTable.Builder> tables = new HashMap<ResourceLocation, LootTable.Builder>();
        tables.put(BuiltInLootTables.f_78759_, LootInjectProvider.getLootTable(61, this.getItemLootEntry((Item)ModItems.RIB_BONE.get(), 10, 2), this.getItemLootEntry((Item)ModItems.SLIME_PEARL.get(), 8, 3), this.getItemLootEntry((Item)ModItems.BAT_WING.get(), 8, 3), this.getItemLootEntry((Item)ModItems.NEBULOUS_HEART.get(), 4, 2), this.getItemLootEntry((Item)ModItems.SQUID_BEAK.get(), 8, 4), this.getItemLootEntry((Item)ModItems.WITCH_HAT.get(), 5, 2), this.getItemLootEntry((Item)ModItems.ANGELIC_FEATHER.get(), 2)));
        tables.put(BuiltInLootTables.f_78764_, LootInjectProvider.getLootTable(44, this.getItemLootEntry((Item)ModItems.RIB_BONE.get(), 10, 3), this.getItemLootEntry((Item)ModItems.CHELICERAE.get(), 10, 2), this.getItemLootEntry((Item)ModItems.CATALYZING_GLAND.get(), 8, 4), this.getItemLootEntry((Item)ModItems.ZOMBIE_HEART.get(), 8, 5), this.getItemLootEntry((Item)ModItems.NEBULOUS_HEART.get(), 5, 3), this.getItemLootEntry((Item)ModItems.MOLTEN_CORE.get(), 5, 2), this.getItemLootEntry((Item)ModItems.SQUID_BEAK.get(), 8, 4), this.getItemLootEntry((Item)ModItems.ANGELIC_FEATHER.get(), 2)));
        tables.put(BuiltInLootTables.f_78741_, LootInjectProvider.getLootTable(64, this.getItemLootEntry((Item)ModItems.NEBULOUS_HEART.get(), 30, 5), this.getItemLootEntry((Item)ModItems.ENDER_STAFF.get(), 5), this.getItemLootEntry((Item)ModItems.RENDING_GALE.get(), 1)));
        tables.put(BuiltInLootTables.f_78688_, LootInjectProvider.getLootTable(60, this.getItemLootEntry((Item)ModItems.FROZEN_CORE.get(), 40, 5)));
        tables.put(BuiltInLootTables.f_78686_, LootInjectProvider.getLootTable(62, this.getItemLootEntry((Item)ModItems.RIB_BONE.get(), 10, 3), this.getItemLootEntry((Item)ModItems.CATALYZING_GLAND.get(), 7, 3), this.getItemLootEntry((Item)ModItems.BAT_WING.get(), 7, 3), this.getItemLootEntry((Item)ModItems.NEBULOUS_HEART.get(), 6, 3), this.getItemLootEntry((Item)ModItems.ANGELIC_FEATHER.get(), 2)));
        tables.put(BuiltInLootTables.f_78760_, LootInjectProvider.getLootTable(61, this.getItemLootEntry((Item)ModItems.WITHERED_RIB.get(), 20, 2), this.getItemLootEntry((Item)ModItems.SLIME_PEARL.get(), 8), this.getItemLootEntry((Item)ModItems.MOLTEN_CORE.get(), 8, 2), this.getItemLootEntry((Item)ModItems.VOID_TEAR.get(), 1), this.getItemLootEntry((Item)ModItems.SALAMANDER_EYE.get(), 1), this.getItemLootEntry((Item)ModBlocks.INTERDICTION_TORCH_ITEM.get(), 1)));
        tables.put(BuiltInLootTables.f_78742_, LootInjectProvider.getLootTable(68, this.getItemLootEntry((Item)ModItems.RIB_BONE.get(), 8, 2), this.getItemLootEntry((Item)ModItems.CHELICERAE.get(), 8, 2), this.getItemLootEntry((Item)ModItems.ZOMBIE_HEART.get(), 8, 2), this.getItemLootEntry((Item)ModItems.WITCH_HAT.get(), 3, 2), this.getItemLootEntry((Item)ModItems.GLOWING_WATER.get(), 5, 2)));
        tables.put(BuiltInLootTables.f_78763_, LootInjectProvider.getLootTable(64, this.getItemLootEntry((Item)ModItems.RIB_BONE.get(), 7, 3), this.getItemLootEntry((Item)ModItems.SLIME_PEARL.get(), 8, 4), this.getItemLootEntry((Item)ModItems.NEBULOUS_HEART.get(), 8, 4), this.getItemLootEntry((Item)ModItems.FROZEN_CORE.get(), 7, 4), this.getItemLootEntry((Item)ModItems.ANGELHEART_VIAL.get(), 4, 2), this.getItemLootEntry((Item)ModItems.SHEARS_OF_WINTER.get(), 2)));
        tables.put(BuiltInLootTables.f_78762_, LootInjectProvider.getLootTable(55, this.getItemLootEntry((Item)ModItems.RIB_BONE.get(), 7, 3), this.getItemLootEntry((Item)ModItems.WITHERED_RIB.get(), 5, 3), this.getItemLootEntry((Item)ModItems.SLIME_PEARL.get(), 9, 3), this.getItemLootEntry((Item)ModItems.NEBULOUS_HEART.get(), 9, 3), this.getItemLootEntry((Item)ModItems.FROZEN_CORE.get(), 7, 3), this.getItemLootEntry((Item)ModItems.ANGELHEART_VIAL.get(), 8, 4)));
        tables.put(BuiltInLootTables.f_78761_, LootInjectProvider.getLootTable(92, this.getItemLootEntry((Item)ModItems.SLIME_PEARL.get(), 8, 4)));
        tables.put(BuiltInLootTables.f_78743_, LootInjectProvider.getLootTable(78, this.getItemLootEntry((Item)ModItems.ZOMBIE_HEART.get(), 10, 5), this.getItemLootEntry((Item)ModItems.WITCH_HAT.get(), 5, 2), this.getItemLootEntry((Item)ModItems.GLOWING_WATER.get(), 7, 4)));
        for (Map.Entry e : tables.entrySet()) {
            Path path = LootInjectProvider.getPath(this.generator.m_123916_(), (ResourceLocation)e.getKey());
            DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)LootTables.m_79200_((LootTable)((LootTable.Builder)e.getValue()).m_79165_(LootContextParamSets.f_81411_).m_79167_()), (Path)path);
        }
        tables.clear();
        tables.put(EntityType.f_20549_.m_20677_(), LootInjectProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.BAT_WING.get(), 1)));
        tables.put(EntityType.f_20551_.m_20677_(), LootInjectProvider.getEntityLootTable(0.03f, 0.04f, 0.12f, this.getItemLootEntry((Item)ModItems.MOLTEN_CORE.get(), 1)));
        tables.put(EntityType.f_20554_.m_20677_(), LootInjectProvider.getEntityLootTable(0.03f, 0.04f, 0.12f, this.getItemLootEntry((Item)ModItems.CHELICERAE.get(), 1)));
        CompoundTag poweredTag = new CompoundTag();
        poweredTag.m_128379_("powered", true);
        tables.put(EntityType.f_20558_.m_20677_(), LootInjectProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.CATALYZING_GLAND.get(), 1)).m_79161_(LootPool.m_79043_().name("powered_creeper").m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.EYE_OF_THE_STORM.get()))).m_6509_(LootItemKilledByPlayerCondition.m_81901_()).m_6509_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)new EntityPredicate.Builder().m_36654_(new NbtPredicate(poweredTag)))).m_6509_(RandomChanceLootingSeveringCondition.randomChanceLootingSevering(0.03f, 0.05f, 0.15f))));
        tables.put(EntityType.f_20566_.m_20677_(), LootInjectProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.NEBULOUS_HEART.get(), 1)));
        tables.put(EntityType.f_20453_.m_20677_(), LootInjectProvider.getEntityLootTable(0.03f, 0.04f, 0.12f, this.getItemLootEntry((Item)ModItems.CATALYZING_GLAND.get(), 1)));
        tables.put(EntityType.f_20455_.m_20677_(), LootInjectProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.GUARDIAN_SPIKE.get(), 1)));
        tables.put(EntityType.f_20458_.m_20677_(), LootInjectProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.ZOMBIE_HEART.get(), 1)));
        tables.put(EntityType.f_20468_.m_20677_(), LootInjectProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.MOLTEN_CORE.get(), 1)));
        tables.put(EntityType.f_20524_.m_20677_(), LootInjectProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.RIB_BONE.get(), 1)));
        tables.put(EntityType.f_20526_.m_20677_(), LootInjectProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.SLIME_PEARL.get(), 1)));
        tables.put(EntityType.f_20528_.m_20677_(), LootInjectProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.FROZEN_CORE.get(), 1)));
        tables.put(EntityType.f_20479_.m_20677_(), LootInjectProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.CHELICERAE.get(), 1)));
        tables.put(EntityType.f_20480_.m_20677_(), LootInjectProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.SQUID_BEAK.get(), 1)));
        tables.put(EntityType.f_20481_.m_20677_(), LootInjectProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.RIB_BONE.get(), 1)));
        tables.put(EntityType.f_20495_.m_20677_(), LootInjectProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.WITCH_HAT.get(), 1)));
        tables.put(EntityType.f_20497_.m_20677_(), LootInjectProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.WITHERED_RIB.get(), 1)));
        tables.put(EntityType.f_20501_.m_20677_(), LootInjectProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.ZOMBIE_HEART.get(), 1)));
        tables.put(EntityType.f_20530_.m_20677_(), LootInjectProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.ZOMBIE_HEART.get(), 1)));
        tables.put(EntityType.f_20531_.m_20677_(), LootInjectProvider.getEntityLootTable(0.03f, 0.04f, 0.12f, this.getItemLootEntry((Item)ModItems.ZOMBIE_HEART.get(), 1)));
        for (Map.Entry e : tables.entrySet()) {
            Path path = LootInjectProvider.getPath(this.generator.m_123916_(), (ResourceLocation)e.getKey());
            DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)LootTables.m_79200_((LootTable)((LootTable.Builder)e.getValue()).m_79165_(LootContextParamSets.f_81415_).m_79167_()), (Path)path);
        }
    }

    public String m_6055_() {
        return "SophisticatedBackpacks chest loot additions";
    }

    private static Path getPath(Path root, ResourceLocation id) {
        return root.resolve("data/reliquary/loot_tables/inject/" + id.m_135815_() + ".json");
    }

    private LootPoolEntryContainer.Builder<?> getItemLootEntry(Item item, int weight, int maxCount) {
        return LootItem.m_79579_((ItemLike)item).m_79707_(weight).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)maxCount)));
    }

    private LootPoolEntryContainer.Builder<?> getItemLootEntry(Item item, int weight) {
        return LootItem.m_79579_((ItemLike)item).m_79707_(weight);
    }

    private static LootTable.Builder getLootTable(int emptyWeight, LootPoolEntryContainer.Builder<?> ... entries) {
        LootPool.Builder pool = LootPool.m_79043_().name("main");
        for (LootPoolEntryContainer.Builder<?> entry : entries) {
            pool.m_79076_(entry);
        }
        pool.m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(emptyWeight));
        return LootTable.m_79147_().m_79161_(pool);
    }

    private static LootTable.Builder getEntityLootTable(float baseChance, float lootingMultiplier, float severingMultiplier, LootPoolEntryContainer.Builder<?> ... entries) {
        LootPool.Builder pool = LootPool.m_79043_().name("main");
        for (LootPoolEntryContainer.Builder<?> entry : entries) {
            pool.m_79076_(entry);
        }
        pool.m_6509_(LootItemKilledByPlayerCondition.m_81901_());
        pool.m_6509_(RandomChanceLootingSeveringCondition.randomChanceLootingSevering(baseChance, lootingMultiplier, severingMultiplier));
        return LootTable.m_79147_().m_79161_(pool);
    }
}

