/*
 * Decompiled with CFR 0.152.
 */
package reliquary.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockLootProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final Map<Block, Function<Block, LootTable.Builder>> functionTable = new HashMap<Block, Function<Block, LootTable.Builder>>();

    BlockLootProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(HashCache cache) throws IOException {
        HashMap<ResourceLocation, LootTable.Builder> tables = new HashMap<ResourceLocation, LootTable.Builder>();
        for (Block block : ForgeRegistries.BLOCKS) {
            if (!"reliquary".equals(block.getRegistryName().m_135827_())) continue;
            Function<Block, LootTable.Builder> func = this.functionTable.getOrDefault(block, BlockLootProvider::genRegular);
            tables.put(block.getRegistryName(), func.apply(block));
        }
        for (Map.Entry e : tables.entrySet()) {
            Path path = BlockLootProvider.getPath(this.generator.m_123916_(), (ResourceLocation)e.getKey());
            DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)LootTables.m_79200_((LootTable)((LootTable.Builder)e.getValue()).m_79165_(LootContextParamSets.f_81421_).m_79167_()), (Path)path);
        }
    }

    public String m_6055_() {
        return "Reliquary block loot tables";
    }

    private static Path getPath(Path root, ResourceLocation id) {
        return root.resolve("data/" + id.m_135827_() + "/loot_tables/blocks/" + id.m_135815_() + ".json");
    }

    private static LootTable.Builder genRegular(Block b) {
        LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)b);
        LootPool.Builder pool = LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entry);
        return LootTable.m_79147_().m_79161_(pool);
    }
}

