/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import reliquary.Reliquary;
import reliquary.init.ModBlocks;
import reliquary.init.ModItems;
import reliquary.items.MobCharmFragmentItem;
import reliquary.items.MobCharmItem;
import reliquary.util.RegistryHelper;
import reliquary.util.potions.XRPotionHelper;

public class ItemDescriptionBuilder {
    private ItemDescriptionBuilder() {
    }

    public static void addIngredientInfo(IRecipeRegistration registration) {
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.ALKAHESTRY_TOME.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.MERCY_CROSS.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.ANGELHEART_VIAL.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.ANGELIC_FEATHER.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.APHRODITE_POTION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.POTION_ESSENCE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.DESTRUCTION_CATALYST.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.EMPEROR_CHALICE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.ENDER_STAFF.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.FERTILE_POTION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.FORTUNE_COIN.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.GLACIAL_STAFF.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.GLOWING_WATER.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.HOLY_HAND_GRENADE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.HANDGUN.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.GRIP_ASSEMBLY.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.BARREL_ASSEMBLY.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.HAMMER_ASSEMBLY.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.HARVEST_ROD.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.HERO_MEDALLION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.ICE_MAGUS_ROD.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.INFERNAL_CHALICE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.INFERNAL_CLAWS.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.INFERNAL_TEAR.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.KRAKEN_SHELL.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.MIDAS_TOUCHSTONE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.PHOENIX_DOWN.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.PYROMANCER_STAFF.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.RENDING_GALE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.ROD_OF_LYSSA.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.SOJOURNER_STAFF.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.TIPPED_ARROW.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.VOID_TEAR.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.WITCH_HAT.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.WITHERLESS_ROSE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.EMPTY_POTION_VIAL.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.POTION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.SPLASH_POTION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.LINGERING_POTION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.MOB_CHARM_BELT.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.ZOMBIE_HEART.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.SQUID_BEAK.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.RIB_BONE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.CATALYZING_GLAND.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.CHELICERAE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.SLIME_PEARL.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.KRAKEN_SHELL_FRAGMENT.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.BAT_WING.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.WITHERED_RIB.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.MOLTEN_CORE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.EYE_OF_THE_STORM.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.FERTILE_ESSENCE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.FROZEN_CORE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.NEBULOUS_HEART.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.INFERNAL_CLAW.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.GUARDIAN_SPIKE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.CRIMSON_CLOTH.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.LANTERN_OF_PARANOIA.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.MAGICBANE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.SALAMANDER_EYE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.SERPENT_STAFF.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.SHEARS_OF_WINTER.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.TWILIGHT_CLOAK.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.GLOWING_BREAD.get());
        ItemDescriptionBuilder.registerCharmFragmentItemsDescription(registration);
        ItemDescriptionBuilder.registerCharmItemsDescription(registration);
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.EMPTY_MAGAZINE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.EMPTY_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.NEUTRAL_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.EXORCISM_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.BLAZE_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.ENDER_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.CONCUSSIVE_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.BUSTER_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.SEEKER_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.SAND_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.STORM_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.NEUTRAL_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.EXORCISM_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.BLAZE_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.ENDER_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.CONCUSSIVE_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.BUSTER_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.SEEKER_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.SAND_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.STORM_BULLET.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModBlocks.ALKAHESTRY_ALTAR_ITEM.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModBlocks.APOTHECARY_CAULDRON_ITEM.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModBlocks.APOTHECARY_MORTAR_ITEM.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModBlocks.INTERDICTION_TORCH_ITEM.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModBlocks.WRAITH_NODE_ITEM.get());
        ItemDescriptionBuilder.addStacksIngredientInfo(registration, ModBlocks.PEDESTAL_ITEMS.values().stream().map(ro -> new ItemStack((ItemLike)ro.get())).collect(Collectors.toList()), "pedestal");
        ItemDescriptionBuilder.addStacksIngredientInfo(registration, ModBlocks.PASSIVE_PEDESTAL_ITEMS.values().stream().map(ro -> new ItemStack((ItemLike)ro.get())).collect(Collectors.toList()), "passive_pedestal");
    }

    private static void registerItemDescription(IRecipeRegistration registration, Item item) {
        NonNullList subItems = NonNullList.m_122779_();
        item.m_6787_(Reliquary.ITEM_GROUP, subItems);
        if (!subItems.isEmpty()) {
            ItemDescriptionBuilder.addStacksIngredientInfo(registration, item, (List<ItemStack>)subItems, new String[0]);
        }
    }

    private static void addStacksIngredientInfo(IRecipeRegistration registration, Item item, List<ItemStack> items, String ... additionalKeys) {
        String[] langKeys;
        String regName = RegistryHelper.getRegistryName(item).m_135815_();
        if (additionalKeys.length > 0) {
            langKeys = new String[additionalKeys.length + 1];
            langKeys[0] = regName;
            System.arraycopy(additionalKeys, 0, langKeys, 1, additionalKeys.length);
        } else {
            langKeys = new String[]{regName};
        }
        ItemDescriptionBuilder.addStacksIngredientInfo(registration, items, langKeys);
    }

    private static void addStacksIngredientInfo(IRecipeRegistration registration, List<ItemStack> items, String ... langKeys) {
        registration.addIngredientInfo(items, VanillaTypes.ITEM, ItemDescriptionBuilder.getTranslationKeys(langKeys));
    }

    private static Component[] getTranslationKeys(String ... langKeys) {
        Component[] components = new Component[langKeys.length];
        for (int i = 0; i < langKeys.length; ++i) {
            components[i] = new TranslatableComponent(String.format("jei.%s.description.%s", "reliquary", langKeys[i].replace('/', '.')));
        }
        return components;
    }

    private static void registerCharmFragmentItemsDescription(IRecipeRegistration registration) {
        MobCharmFragmentItem item = (MobCharmFragmentItem)ModItems.MOB_CHARM_FRAGMENT.get();
        ItemDescriptionBuilder.registerCharmBasedItems(registration, item, MobCharmFragmentItem::getEntityEggRegistryName);
    }

    private static void registerCharmItemsDescription(IRecipeRegistration registration) {
        MobCharmItem item = (MobCharmItem)ModItems.MOB_CHARM.get();
        ItemDescriptionBuilder.registerCharmBasedItems(registration, item, MobCharmItem::getEntityEggRegistryName);
    }

    private static void registerCharmBasedItems(IRecipeRegistration registration, Item item, Function<ItemStack, ResourceLocation> getEntityRegistryName) {
        NonNullList subItems = NonNullList.m_122779_();
        item.m_6787_(Reliquary.ITEM_GROUP, subItems);
        for (ItemStack subItem : subItems) {
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(getEntityRegistryName.apply(subItem));
            if (entityType == null) continue;
            String path = RegistryHelper.getRegistryName(item).m_135815_();
            String itemDescriptionKey = String.format("jei.%s.description.%s", "reliquary", path.replace('/', '.'));
            String entityName = entityType.m_20676_().getString();
            registration.addIngredientInfo((Object)subItem, VanillaTypes.ITEM, new Component[]{new TranslatableComponent(itemDescriptionKey, new Object[]{entityName, entityName})});
        }
    }

    private static void registerPotionAmmoItemsDescription(IRecipeRegistration registration, Item item) {
        NonNullList subItems = NonNullList.m_122779_();
        NonNullList potionItems = NonNullList.m_122779_();
        item.m_6787_(Reliquary.ITEM_GROUP, subItems);
        for (ItemStack subItem : subItems) {
            if (XRPotionHelper.getPotionEffectsFromStack(subItem).isEmpty()) continue;
            potionItems.add((Object)subItem);
        }
        if (!potionItems.isEmpty()) {
            ItemDescriptionBuilder.addStacksIngredientInfo(registration, item, (List<ItemStack>)potionItems, "ammo_potion");
        }
        subItems = NonNullList.m_122779_();
        NonNullList nonPotionItems = NonNullList.m_122779_();
        item.m_6787_(Reliquary.ITEM_GROUP, subItems);
        for (ItemStack subItem : subItems) {
            if (!XRPotionHelper.getPotionEffectsFromStack(subItem).isEmpty()) continue;
            nonPotionItems.add((Object)subItem);
        }
        if (!nonPotionItems.isEmpty()) {
            ItemDescriptionBuilder.addStacksIngredientInfo(registration, item, (List<ItemStack>)nonPotionItems, new String[0]);
        }
    }
}

