/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.curios;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import reliquary.client.model.MobCharmBeltModel;
import reliquary.compat.curios.CuriosBaubleItemWrapper;
import reliquary.compat.curios.CuriosCharmInventoryHandler;
import reliquary.compat.curios.CuriosFortuneCoinToggler;
import reliquary.compat.curios.MobCharmBeltRenderer;
import reliquary.init.ModItems;
import reliquary.items.MobCharmItem;
import reliquary.items.util.ICuriosItem;
import reliquary.util.InventoryHelper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosCompat {
    private static final EmptyCuriosHandler EMPTY_HANDLER = new EmptyCuriosHandler();

    public CuriosCompat() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::sendImc);
        modEventBus.addListener(this::setup);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addGenericListener(ItemStack.class, this::onAttachCapabilities);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modEventBus.addListener(this::registerLayerDefinitions));
    }

    private void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(MobCharmBeltRenderer.MOB_CHARM_BELT_LAYER, MobCharmBeltModel::createBodyLayer);
        CuriosRendererRegistry.register((Item)((Item)ModItems.MOB_CHARM_BELT.get()), MobCharmBeltRenderer::new);
    }

    private void sendImc(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.NECKLACE.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BODY.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BELT.getMessageBuilder().build());
    }

    public void onAttachCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        ItemStack stack = (ItemStack)evt.getObject();
        Item item = stack.m_41720_();
        if (this.isCuriosItem(item)) {
            this.addCuriosCapability(evt, stack);
        }
    }

    private boolean isCuriosItem(Item item) {
        return item.getRegistryName() != null && item.getRegistryName().m_135827_().equals("reliquary") && item instanceof ICuriosItem;
    }

    private void addCuriosCapability(AttachCapabilitiesEvent<ItemStack> evt, final ItemStack stack) {
        evt.addCapability(new ResourceLocation("reliquary", stack.m_41720_().getRegistryName().m_135815_() + "_curios"), new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, LazyOptional.of(() -> new CuriosBaubleItemWrapper(stack)));
            }
        });
    }

    private void setup(FMLCommonSetupEvent event) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> new CuriosFortuneCoinToggler().registerSelf());
        ((MobCharmItem)ModItems.MOB_CHARM.get()).setCharmInventoryHandler(new CuriosCharmInventoryHandler());
        InventoryHelper.addBaublesItemHandlerFactory((player, type) -> (IItemHandler)CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).map(handler -> handler.getStacksHandler(type.getIdentifier()).map(ICurioStacksHandler::getStacks).orElse(EMPTY_HANDLER)).orElse(EMPTY_HANDLER));
    }

    public static Optional<ItemStack> getStackInSlot(LivingEntity entity, String slotName, int slot) {
        return CuriosApi.getCuriosHelper().getCuriosHandler(entity).map(handler -> handler.getStacksHandler(slotName).map(sh -> sh.getStacks().getStackInSlot(slot))).orElse(Optional.empty());
    }

    public static void setStackInSlot(LivingEntity entity, String slotName, int slot, ItemStack stack) {
        CuriosApi.getCuriosHelper().getCuriosHandler(entity).ifPresent(handler -> handler.getStacksHandler(slotName).ifPresent(sh -> sh.getStacks().setStackInSlot(slot, stack)));
    }

    private static class EmptyCuriosHandler
    extends ItemStackHandler
    implements IDynamicStackHandler {
        private EmptyCuriosHandler() {
        }

        public void setPreviousStackInSlot(int i, @Nonnull ItemStack itemStack) {
        }

        public ItemStack getPreviousStackInSlot(int i) {
            return ItemStack.f_41583_;
        }

        public void grow(int i) {
        }

        public void shrink(int i) {
        }
    }
}

