/*
 * Decompiled with CFR 0.152.
 */
package reliquary.blocks.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import reliquary.blocks.AlkahestryAltarBlock;
import reliquary.blocks.tile.BlockEntityBase;
import reliquary.init.ModBlocks;
import reliquary.reference.Settings;
import reliquary.util.WorldHelper;

public class AlkahestryAltarBlockEntity
extends BlockEntityBase {
    private int cycleTime = 0;
    private boolean isActive;
    private int redstoneCount = 0;

    public AlkahestryAltarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.ALKAHESTRY_ALTAR_TILE_TYPE.get(), pos, state);
    }

    public void serverTick(Level level, BlockPos pos) {
        if (level.f_46443_ || !this.isActive || level.m_46462_() || !level.m_45527_(pos.m_7494_())) {
            return;
        }
        if (this.cycleTime > 0) {
            --this.cycleTime;
        } else {
            this.isActive = false;
            level.m_46597_(pos.m_7494_(), Blocks.f_50141_.m_49966_());
            AlkahestryAltarBlock.updateAltarBlockState(this.isActive(), level, pos);
        }
    }

    public void startCycle(Level level) {
        int defaultCycleTime = (Integer)Settings.COMMON.blocks.altar.timeInMinutes.get() * 60 * 20;
        int maximumVariance = (Integer)Settings.COMMON.blocks.altar.maximumTimeVarianceInMinutes.get() * 60 * 20;
        this.cycleTime = (int)((double)defaultCycleTime + (double)maximumVariance * level.f_46441_.nextGaussian());
        this.redstoneCount = 0;
        this.isActive = true;
    }

    public void stopCycle() {
        this.isActive = false;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.cycleTime = compound.m_128448_("cycleTime");
        this.redstoneCount = compound.m_128448_("redstoneCount");
        this.isActive = compound.m_128471_("isActive");
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128376_("cycleTime", (short)this.cycleTime);
        compound.m_128376_("redstoneCount", (short)this.redstoneCount);
        compound.m_128379_("isActive", this.isActive);
    }

    public void addRedstone(Level level, BlockPos pos) {
        ++this.redstoneCount;
        if (this.redstoneCount >= AlkahestryAltarBlockEntity.getRedstoneCost()) {
            AlkahestryAltarBlock.updateAltarBlockState(true, level, pos);
        }
        WorldHelper.notifyBlockUpdate(this);
    }

    private static int getRedstoneCost() {
        return (Integer)Settings.COMMON.blocks.altar.redstoneCost.get();
    }

    public int getRedstoneCount() {
        return this.redstoneCount;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public int getCycleTime() {
        return this.cycleTime;
    }
}

