/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes.blocks;

import com.nick.chimes.blocks.WindChimeBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public class WindChimeTyableBlock
extends WindChimeBlock {
    public static final BooleanProperty SILENCED = BooleanProperty.m_61465_((String)"tied");

    public WindChimeTyableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_, HALF, SILENCED, WATERLOGGED});
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.m_61143_((Property)HALF);
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_183324_().m_183582_(currentPos, (Object)Fluids.f_76193_);
        }
        if (facing.m_122434_() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.UPPER == (facing == Direction.DOWN)) {
            return facingState.m_60734_() == this && facingState.m_61143_((Property)HALF) != doubleblockhalf ? (BlockState)((BlockState)stateIn.m_61124_((Property)FACING, (Comparable)((Direction)facingState.m_61143_((Property)FACING)))).m_61124_((Property)SILENCED, (Comparable)((Boolean)facingState.m_61143_((Property)SILENCED))) : Blocks.f_50016_.m_49966_();
        }
        return doubleblockhalf == DoubleBlockHalf.UPPER && facing == Direction.UP && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        if (blockpos.m_123342_() < context.m_43725_().m_151558_() && context.m_43725_().m_8055_(blockpos.m_7495_()).m_60629_(context)) {
            return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)SILENCED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_192917_((Fluid)Fluids.f_76193_)));
        }
        return null;
    }

    public BlockState changeState(BlockState state, Level world, BlockPos pos) {
        state = (BlockState)state.m_61122_((Property)SILENCED);
        world.m_7731_(pos, state, 3);
        return state;
    }

    public void setChiming(BlockState state, Level level, BlockPos pos) {
        this.chime(level, pos);
        this.playChimeSound(level, pos);
        if (state.m_61143_((Property)HALF) == DoubleBlockHalf.UPPER) {
            this.chime(level, pos.m_7495_());
        } else {
            this.chime(level, pos.m_7494_());
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity.m_20184_().m_82553_() > 0.0) {
            // empty if block
        }
        super.m_7892_(state, level, pos, entity);
    }

    @Override
    public void m_5581_(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (!((Boolean)state.m_61143_((Property)SILENCED)).booleanValue()) {
            this.setChiming(state, worldIn, hit.m_82425_());
        } else {
            this.playTieSound(worldIn, hit.m_82425_());
        }
    }

    @Override
    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        if (!player.m_21205_().m_150930_(Items.f_42398_)) {
            if (!((Boolean)state.m_61143_((Property)SILENCED)).booleanValue()) {
                this.playChimeSound(level, pos);
            } else {
                this.playTieSound(level, pos);
            }
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!(player.m_21205_().m_41720_() instanceof AxeItem)) {
            if (!player.m_6047_() && !((Boolean)state.m_61143_((Property)SILENCED)).booleanValue()) {
                this.setChiming(state, worldIn, pos);
                worldIn.m_7967_(EntityType.f_20523_.m_20615_(worldIn));
            }
            if (((Boolean)state.m_61143_((Property)SILENCED)).booleanValue()) {
                this.playTieSound(worldIn, pos);
                this.changeState(state, worldIn, pos);
                worldIn.m_5594_(null, pos, SoundEvents.f_12033_, SoundSource.BLOCKS, 1.0f, 0.75f);
            }
            if (player.m_6047_() && !((Boolean)state.m_61143_((Property)SILENCED)).booleanValue()) {
                this.playTieSound(worldIn, pos);
                this.changeState(state, worldIn, pos);
                worldIn.m_5594_(null, pos, SoundEvents.f_12087_, SoundSource.BLOCKS, 1.0f, 0.75f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

