/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes.blocks;

import com.nick.chimes.blocks.ChimesBlocks;
import com.nick.chimes.blocks.entity.WindChimeBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindChimeBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public WindChimeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF, WATERLOGGED, FACING});
    }

    protected static void removeBottomHalf(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (doubleblockhalf == DoubleBlockHalf.LOWER && (blockstate = world.m_8055_(blockpos = pos.m_7494_())).m_60734_() == state.m_60734_() && blockstate.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            if (!((Boolean)blockstate.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                world.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            }
            if (((Boolean)blockstate.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                world.m_7731_(blockpos, Blocks.f_49990_.m_49966_(), 35);
            }
            world.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    public RenderShape m_7514_(BlockState p_49753_) {
        return RenderShape.MODEL;
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.f_46443_) {
            if (player.m_7500_()) {
                WindChimeBlock.removeBottomHalf(worldIn, pos, state, player);
            } else {
                WindChimeBlock.m_49881_((BlockState)state, (Level)worldIn, (BlockPos)pos, (BlockEntity)null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @javax.annotation.Nullable BlockEntity te, ItemStack stack) {
        super.m_6240_(worldIn, player, pos, Blocks.f_50016_.m_49966_(), te, stack);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        boolean watercheck = worldIn.m_6425_(pos.m_7495_()).m_76152_() == Fluids.f_76193_;
        worldIn.m_7731_(pos, (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 10);
        worldIn.m_7731_(pos.m_7495_(), (BlockState)((BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(watercheck)), 10);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.m_61143_(HALF);
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            // empty if block
        }
        if (facing.m_122434_() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.UPPER == (facing == Direction.DOWN)) {
            return facingState.m_60734_() == this && facingState.m_61143_(HALF) != doubleblockhalf ? (BlockState)stateIn.m_61124_((Property)FACING, (Comparable)((Direction)facingState.m_61143_((Property)FACING))) : Blocks.f_50016_.m_49966_();
        }
        return doubleblockhalf == DoubleBlockHalf.UPPER && facing == Direction.UP && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag;
        BlockPos blockpos = context.m_8083_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean bl = flag = fluidstate.m_76152_() == Fluids.f_76193_;
        if (blockpos.m_123342_() < context.m_43725_().m_151558_() && context.m_43725_().m_8055_(blockpos.m_7495_()).m_60629_(context)) {
            Level world = context.m_43725_();
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        return null;
    }

    protected boolean chime(Level world, BlockPos pos) {
        BlockEntity tileentity = world.m_7702_(pos);
        if (!world.f_46443_ && tileentity instanceof WindChimeBE) {
            ((WindChimeBE)tileentity).chime();
            return true;
        }
        return false;
    }

    public void playChimeSound(Level world, BlockPos pos) {
        this.playChimeSound(world, pos);
    }

    public void playTieSound(Level world, BlockPos pos) {
        this.playTieSound(world, pos);
    }

    protected boolean isValidGround(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return !state.m_60812_(worldIn, pos).m_83263_(Direction.DOWN).m_83281_() || state.m_60783_(worldIn, pos, Direction.DOWN);
    }

    public boolean m_7357_(BlockState p_60475_, BlockGetter p_60476_, BlockPos p_60477_, PathComputationType p_60478_) {
        return false;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        return this.isValidGround(worldIn.m_8055_(blockpos), (BlockGetter)worldIn, blockpos);
    }

    public PushReaction m_5537_(BlockState p_49765_) {
        return PushReaction.DESTROY;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_8133_(BlockState state, Level worldIn, BlockPos pos, int id, int param) {
        super.m_8133_(state, worldIn, pos, id, param);
        BlockEntity tileentity = worldIn.m_7702_(pos);
        return tileentity == null ? false : tileentity.m_7531_(id, param);
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        if (!player.m_21205_().m_150930_(Items.f_42398_)) {
            this.playChimeSound(level, pos);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!(player.m_21205_().m_41720_() instanceof AxeItem)) {
            this.playChimeSound(worldIn, pos);
            this.chime(worldIn, pos);
            if (worldIn.m_8055_(pos).m_61143_(HALF) == DoubleBlockHalf.UPPER && worldIn.m_8055_(pos.m_7495_()).m_60734_() == ChimesBlocks.AMETHYSTCHIMES.get()) {
                this.chime(worldIn, pos.m_7495_());
            } else if (worldIn.m_8055_(pos).m_61143_(HALF) == DoubleBlockHalf.LOWER && worldIn.m_8055_(pos.m_7494_()).m_60734_() == ChimesBlocks.AMETHYSTCHIMES.get()) {
                this.chime(worldIn, pos.m_7494_());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_5581_(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockpos = hit.m_82425_();
        Projectile velSource = projectile;
        this.chime(worldIn, blockpos);
        this.playChimeSound(worldIn, blockpos);
        if (((DoubleBlockHalf)state.m_61143_(HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
            this.chime(worldIn, blockpos.m_7495_());
        } else {
            this.chime(worldIn, blockpos.m_7494_());
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level p_153212_, @NotNull BlockState p_153213_, @NotNull BlockEntityType<T> p_153214_) {
        return (p_155253_, p_155254_, p_155255_, p_155256_) -> ((WindChimeBE)p_155256_).tick();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return null;
    }
}

