/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes.blocks;

import com.nick.chimes.blocks.ChimesBlocks;
import com.nick.chimes.blocks.entity.WindBellBE;
import com.nick.chimes.client.sound.ChimesSounds;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WindBellBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape glass = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    private static final VoxelShape rim = Block.m_49796_((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0);
    private static final VoxelShape glasschime = Shapes.m_83110_((VoxelShape)glass, (VoxelShape)rim);

    protected WindBellBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return glasschime;
    }

    public void m_6402_(Level p_48668_, BlockPos p_48669_, BlockState p_48670_, @Nullable LivingEntity p_48671_, ItemStack p_48672_) {
        if (p_48668_.f_46443_) {
            p_48668_.m_141902_(p_48669_, (BlockEntityType)ChimesBlocks.WIND_BELL_BLOCK_ENTITY.get()).ifPresent(p_187404_ -> p_187404_.fromItem(p_48672_));
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        if (pos.m_123342_() < context.m_43725_().m_151558_() && context.m_43725_().m_8055_(pos).m_60629_(context)) {
            return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(pos).m_192917_((Fluid)Fluids.f_76193_)));
        }
        return null;
    }

    public ItemStack m_7397_(BlockGetter p_48664_, BlockPos p_48665_, BlockState p_48666_) {
        BlockEntity blockentity = p_48664_.m_7702_(p_48665_);
        return blockentity instanceof WindBellBE ? ((WindBellBE)blockentity).getItem() : super.m_7397_(p_48664_, p_48665_, p_48666_);
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public RenderShape m_7514_(BlockState blockState) {
        return super.m_7514_(blockState);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!this.m_7898_(facingState, (LevelReader)worldIn, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected boolean isValidGround(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return !state.m_60812_(worldIn, pos).m_83263_(Direction.DOWN).m_83281_() || state.m_60783_(worldIn, pos, Direction.DOWN);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return this.isValidGround(worldIn.m_8055_(pos.m_7494_()), (BlockGetter)worldIn, pos.m_7494_());
    }

    public boolean m_8133_(BlockState state, Level worldIn, BlockPos pos, int id, int param) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        super.m_8133_(state, worldIn, pos, id, param);
        return tileentity == null ? false : tileentity.m_7531_(id, param);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level level, BlockPos pos, Random randomSource) {
        float chance;
        float f = chance = pos.m_123341_() * 4 % 2 == 0 ? 1.0f : 1.0f;
        if (randomSource.nextDouble() < 0.35) {
            level.m_7785_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), (SoundEvent)ChimesSounds.GLASSCHIME.get(), SoundSource.AMBIENT, 1.0f, 0.7f + (float)Math.random() / 2.0f, false);
        }
    }

    public boolean chime(Level world, BlockPos pos) {
        BlockEntity tileentity = world.m_7702_(pos);
        if (!world.f_46443_ && tileentity instanceof WindBellBE) {
            ((WindBellBE)tileentity).chime();
            return true;
        }
        return false;
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        level.m_6263_(null, (double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_(), (double)((float)pos.m_123343_() + 0.5f), (SoundEvent)ChimesSounds.GLASSCHIME.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        this.chime(worldIn, pos);
        worldIn.m_6263_(null, (double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_(), (double)((float)pos.m_123343_() + 0.5f), (SoundEvent)ChimesSounds.GLASSCHIME.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    public void m_5581_(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockpos = hit.m_82425_();
        if (projectile instanceof ThrownTrident || projectile instanceof Arrow) {
            worldIn.m_46961_(hit.m_82425_(), true);
        } else {
            worldIn.m_6263_(null, (double)((float)blockpos.m_123341_() + 0.5f), (double)blockpos.m_123342_(), (double)((float)blockpos.m_123343_() + 0.5f), (SoundEvent)ChimesSounds.GLASSCHIME.get(), SoundSource.BLOCKS, 1.2f, 1.0f);
            this.chime(worldIn, blockpos);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_153212_, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return (p_155253_, p_155254_, p_155255_, p_155256_) -> ((WindBellBE)p_155256_).tick();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_152198_, BlockState p_152199_) {
        return new WindBellBE(p_152198_, p_152199_);
    }
}

