/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.foodeffects.config.library.util;

import java.lang.reflect.Field;
import java.util.Objects;
import org.infernalstudios.foodeffects.config.library.annotation.Category;
import org.infernalstudios.foodeffects.config.library.annotation.Configurable;
import org.infernalstudios.foodeffects.config.library.util.annotation.Nullable;

public final class Util {
    private Util() {
    }

    @Nullable
    public static Class<?> getPrimitive(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz must not be null");
        if (clazz.isPrimitive()) {
            return clazz;
        }
        if (Boolean.class.equals(clazz)) {
            return Boolean.TYPE;
        }
        if (Byte.class.equals(clazz)) {
            return Byte.TYPE;
        }
        if (Character.class.equals(clazz)) {
            return Character.TYPE;
        }
        if (Short.class.equals(clazz)) {
            return Short.TYPE;
        }
        if (Integer.class.equals(clazz)) {
            return Integer.TYPE;
        }
        if (Long.class.equals(clazz)) {
            return Long.TYPE;
        }
        if (Float.class.equals(clazz)) {
            return Float.TYPE;
        }
        if (Double.class.equals(clazz)) {
            return Double.TYPE;
        }
        return null;
    }

    public static boolean isNumber(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz must not be null");
        if (clazz.isPrimitive()) {
            clazz = Util.getPrimitive(clazz);
        }
        return Number.class.isAssignableFrom(clazz) || Byte.TYPE.equals(clazz) || Short.TYPE.equals(clazz) || Integer.TYPE.equals(clazz) || Long.TYPE.equals(clazz) || Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz);
    }

    public static String getCategory(Field field) {
        Objects.requireNonNull(field, "field must not be null");
        Configurable configurable = field.getAnnotation(Configurable.class);
        Object category = configurable != null ? configurable.category() : "";
        if ("".equals(category)) {
            category = Util.getCategory(field.getDeclaringClass());
        } else {
            String superCategory = Util.getCategory(field.getDeclaringClass());
            if (!"".equals(superCategory)) {
                category = superCategory + "." + (String)category;
            }
        }
        return category;
    }

    public static String getCategory(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz must not be null");
        Category configurable = clazz.getAnnotation(Category.class);
        Object category = configurable != null ? configurable.value() : "";
        Class<?> clazz2 = clazz.getDeclaringClass();
        if (clazz2 != null) {
            if ("".equals(category)) {
                category = Util.getCategory(clazz2);
            } else {
                String superCategory = Util.getCategory(clazz2);
                if (!"".equals(superCategory)) {
                    category = superCategory + "." + (String)category;
                }
            }
        }
        return category;
    }
}

