/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.foodeffects.config.library.element.handler;

import java.lang.reflect.Field;
import org.infernalstudios.foodeffects.config.library.annotation.DoubleRange;
import org.infernalstudios.foodeffects.config.library.annotation.FloatRange;
import org.infernalstudios.foodeffects.config.library.annotation.IntegerRange;
import org.infernalstudios.foodeffects.config.library.element.IConfigElement;
import org.infernalstudios.foodeffects.config.library.element.NumberConfigElement;
import org.infernalstudios.foodeffects.config.library.element.handler.IConfigElementHandler;
import org.infernalstudios.foodeffects.config.library.util.annotation.Nullable;

public final class IntegerElementHandler
implements IConfigElementHandler<Integer, Number> {
    public static final IntegerElementHandler INSTANCE = new IntegerElementHandler();

    private IntegerElementHandler() {
    }

    @Override
    public IConfigElement<Integer> create(Field field) {
        DoubleRange rangeD = field.getAnnotation(DoubleRange.class);
        FloatRange rangeF = field.getAnnotation(FloatRange.class);
        IntegerRange rangeI = field.getAnnotation(IntegerRange.class);
        if (rangeD != null) {
            System.err.println(String.format("WARNING: %s has a %s annotation, but is an int.", field.toGenericString(), DoubleRange.class.getSimpleName()));
        }
        if (rangeF != null) {
            System.err.println(String.format("WARNING: %s has an %s annotation, but is an int.", field.toGenericString(), FloatRange.class.getSimpleName()));
        }
        int min = Integer.MIN_VALUE;
        int max = Integer.MAX_VALUE;
        if (rangeI != null) {
            min = rangeI.min();
            max = rangeI.max();
        }
        return new NumberConfigElement<Integer>(field, min, max, this);
    }

    @Override
    public IConfigElement<Integer> update(IConfigElement<Integer> element, @Nullable Integer value) {
        if (value != null) {
            element.set((int)value);
        }
        return element;
    }

    @Override
    public Number serialize(IConfigElement<Integer> element) {
        Integer value = element.getFromField();
        return value == null ? element.getDefault() : value;
    }

    @Override
    public Integer deserialize(Number obj) {
        return obj.intValue();
    }

    @Override
    public boolean canHandle(Class<?> clazz) {
        return Integer.class.equals(clazz) || Integer.TYPE.equals(clazz) || Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz);
    }
}

