/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.foodeffects.config.library.element.handler;

import java.lang.reflect.Field;
import org.infernalstudios.foodeffects.config.library.annotation.DoubleRange;
import org.infernalstudios.foodeffects.config.library.annotation.FloatRange;
import org.infernalstudios.foodeffects.config.library.annotation.IntegerRange;
import org.infernalstudios.foodeffects.config.library.element.IConfigElement;
import org.infernalstudios.foodeffects.config.library.element.NumberConfigElement;
import org.infernalstudios.foodeffects.config.library.element.handler.IConfigElementHandler;
import org.infernalstudios.foodeffects.config.library.util.annotation.Nullable;

public final class FloatElementHandler
implements IConfigElementHandler<Float, Number> {
    public static final FloatElementHandler INSTANCE = new FloatElementHandler();

    private FloatElementHandler() {
    }

    @Override
    public IConfigElement<Float> create(Field field) {
        DoubleRange rangeD = field.getAnnotation(DoubleRange.class);
        FloatRange rangeF = field.getAnnotation(FloatRange.class);
        IntegerRange rangeI = field.getAnnotation(IntegerRange.class);
        if (rangeD != null) {
            System.err.println(String.format("WARNING: %s has a %s annotation, but is a float.", field.toGenericString(), DoubleRange.class.getSimpleName()));
        }
        if (rangeI != null) {
            System.err.println(String.format("WARNING: %s has an %s annotation, but is a float.", field.toGenericString(), IntegerRange.class.getSimpleName()));
        }
        float min = Float.MIN_VALUE;
        float max = Float.MAX_VALUE;
        if (rangeF != null) {
            min = rangeF.min();
            max = rangeF.max();
        }
        return new NumberConfigElement<Float>(field, Float.valueOf(min), Float.valueOf(max), this);
    }

    @Override
    public IConfigElement<Float> update(IConfigElement<Float> element, @Nullable Float value) {
        if (value != null) {
            element.set(Float.valueOf(value.floatValue()));
        }
        return element;
    }

    @Override
    public Number serialize(IConfigElement<Float> element) {
        Float value = element.getFromField();
        return value == null ? element.getDefault() : value;
    }

    @Override
    public Float deserialize(Number obj) {
        return Float.valueOf(obj.floatValue());
    }

    @Override
    public boolean canHandle(Class<?> clazz) {
        return Float.class.equals(clazz) || Float.TYPE.equals(clazz) || Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz);
    }
}

